/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.dao;

import com.ksoot.problem.spring.advice.dao.ConstraintNameResolver;
import com.ksoot.problem.spring.advice.dao.DBType;
import com.ksoot.problem.spring.advice.dao.DaoAdviceTraits;
import com.ksoot.problem.spring.advice.dao.Database;
import com.ksoot.problem.spring.config.ProblemConfigException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;

public abstract class AbstractDaoExceptionHandler<T, R>
implements DaoAdviceTraits<T, R> {
    protected final Map<DBType, ConstraintNameResolver> constraintNameResolvers;
    protected final Database database;

    protected AbstractDaoExceptionHandler(List<ConstraintNameResolver> constraintNameResolvers, Environment env) {
        this.constraintNameResolvers = CollectionUtils.isNotEmpty(constraintNameResolvers) ? constraintNameResolvers.stream().collect(Collectors.toMap(ConstraintNameResolver::dbType, Function.identity())) : Collections.EMPTY_MAP;
        String dbPlateform = env.getProperty("spring.jpa.database");
        if (this.constraintNameResolvers.containsKey((Object)DBType.POSTGRESQL) || this.constraintNameResolvers.containsKey((Object)DBType.SQL_SERVER) || this.constraintNameResolvers.containsKey((Object)DBType.MYSQL) || this.constraintNameResolvers.containsKey((Object)DBType.ORACLE)) {
            if (StringUtils.isEmpty((CharSequence)dbPlateform)) {
                throw new ProblemConfigException("Property \"spring.jpa.database\" not found. Please specify database plateform in configurations");
            }
            this.database = Database.valueOf(dbPlateform);
        } else {
            this.database = null;
        }
    }

    @Override
    public String resolveConstraintName(String exceptionMessage) {
        if (exceptionMessage.contains("WriteError")) {
            return this.constraintNameResolvers.get((Object)DBType.MONGO_DB).resolveConstraintName(exceptionMessage);
        }
        switch (this.database) {
            case SQL_SERVER: {
                return this.constraintNameResolvers.get((Object)DBType.SQL_SERVER).resolveConstraintName(exceptionMessage);
            }
            case POSTGRESQL: {
                return this.constraintNameResolvers.get((Object)DBType.POSTGRESQL).resolveConstraintName(exceptionMessage);
            }
            case MYSQL: {
                return this.constraintNameResolvers.get((Object)DBType.MYSQL).resolveConstraintName(exceptionMessage);
            }
            case ORACLE: {
                return this.constraintNameResolvers.get((Object)DBType.ORACLE).resolveConstraintName(exceptionMessage);
            }
        }
        throw new IllegalStateException("constraintNameResolver bean could not be found, add ConstraintNameResolver implementation for: " + this.database);
    }
}

