/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.http;

import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.Collection;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface HttpMediaTypeNotAcceptableAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException exception, T request) {
        List supportedMediaTypes = exception.getSupportedMediaTypes();
        ThrowableProblem problem = this.toProblem((Throwable)exception, HttpStatus.NOT_ACCEPTABLE, ProblemMessageSourceResolver.of("detail.media.type.not.acceptable", "Media Type Not Acceptable, except: {0}", new Object[]{MimeTypeUtils.toString((Collection)supportedMediaTypes)}));
        return this.create((Throwable)exception, request, HttpStatus.NOT_ACCEPTABLE, problem);
    }
}

