/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.network;

import com.ksoot.problem.spring.advice.AdviceTrait;
import net.jodah.failsafe.CircuitBreakerOpenException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface CircuitBreakerOpenAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleCircuitBreakerOpen(CircuitBreakerOpenException exception, T request) {
        long delay = exception.getCircuitBreaker().getRemainingDelay().getSeconds();
        HttpHeaders headers = this.retryAfter(delay);
        return this.create((Throwable)exception, request, HttpStatus.SERVICE_UNAVAILABLE, headers);
    }

    default public HttpHeaders retryAfter(long delay) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Retry-After", String.valueOf(delay));
        return headers;
    }
}

