/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.security;

import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface AccessDeniedAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleAccessDeniedException(AccessDeniedException exception, T request) {
        ThrowableProblem problem = this.toProblem((Throwable)exception, HttpStatus.FORBIDDEN, ProblemMessageSourceResolver.of("detail.security.access.denied", exception.getMessage()));
        return this.create((Throwable)exception, request, HttpStatus.FORBIDDEN, problem);
    }
}

