/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.validation;

import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.validation.BaseValidationAdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.LinkedHashMap;
import org.springframework.beans.TypeMismatchException;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface TypeMismatchAdviceTrait<T, R>
extends BaseValidationAdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleTypeMismatch(TypeMismatchException exception, T request) {
        HttpStatus status = this.defaultConstraintViolationStatus();
        String propertyName = exception.getPropertyName();
        String errorKey = exception.getErrorCode() + "." + propertyName;
        String codeCode = "code.type.mismatch." + errorKey;
        String titleCode = "title.type.mismatch." + errorKey;
        String detailCode = "detail.type.mismatch." + errorKey;
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(4);
        parameters.put("propertyPath", propertyName);
        ThrowableProblem problem = this.toProblem((Throwable)exception, (MessageSourceResolvable)ProblemMessageSourceResolver.of(codeCode, status.value()), (MessageSourceResolvable)ProblemMessageSourceResolver.of(titleCode, status.getReasonPhrase()), (MessageSourceResolvable)ProblemMessageSourceResolver.of(detailCode, exception.getMostSpecificCause().toString()), parameters);
        return this.create((Throwable)exception, request, status, problem);
    }
}

