/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.webflux;

import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.validation.BaseBindingResultHandlingAdviceTrait;
import com.ksoot.problem.spring.advice.validation.ViolationVM;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.support.WebExchangeBindException;

interface WebExchangeBindAdviceTrait<T, R>
extends BaseBindingResultHandlingAdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleWebExchangeBindException(WebExchangeBindException exception, T request) {
        List<ViolationVM> violations = this.handleBindingResult(exception.getBindingResult(), (Throwable)exception);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(4);
        parameters.put("violations", violations);
        ThrowableProblem problem = this.toProblem((Throwable)exception, (MessageSourceResolvable)ProblemMessageSourceResolver.of("code.constraint.violation"), (MessageSourceResolvable)ProblemMessageSourceResolver.of("title.constraint.violation"), (MessageSourceResolvable)ProblemMessageSourceResolver.of("detail.constraint.violation", exception.getMessage()), parameters);
        return this.create((Throwable)exception, request, this.defaultConstraintViolationStatus(), problem);
    }
}

