/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import com.ksoot.problem.core.ThrowableProblem;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractThrowableProblem
extends ThrowableProblem {
    private static final long serialVersionUID = 7657146691407810390L;
    private final String code;
    private final String title;
    private final String detail;
    private final Map<String, Object> parameters;

    protected AbstractThrowableProblem() {
        this((String)null, (String)null);
    }

    protected AbstractThrowableProblem(String code, String title) {
        this(code, title, null);
    }

    protected AbstractThrowableProblem(String code, String title, String detail) {
        this(code, title, detail, null);
    }

    protected AbstractThrowableProblem(String code, String title, String detail, @Nullable ThrowableProblem cause) {
        this(code, title, detail, cause, null);
    }

    protected AbstractThrowableProblem(String code, String title, String detail, @Nullable ThrowableProblem cause, @Nullable Map<String, Object> parameters) {
        super(cause);
        this.code = code;
        this.title = title;
        this.detail = detail;
        this.parameters = Optional.ofNullable(parameters).orElseGet(LinkedHashMap::new);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDetail() {
        return this.detail;
    }

    @Override
    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    void set(String key, Object value) {
        this.parameters.put(key, value);
    }
}

