/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import com.ksoot.problem.core.Problem;
import com.ksoot.problem.core.ProblemSupport;
import com.ksoot.problem.core.ThrowableProblem;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public final class ApplicationProblem
extends RuntimeException
implements ProblemSupport {
    private final HttpStatus status;
    private final String errorKey;
    private final String defaultDetail;
    private final Object[] detailArgs;
    private final ThrowableProblem cause;
    private final Map<String, Object> parameters;
    private final Problem problem;

    private ApplicationProblem(HttpStatus status, Problem problem, String errorKey, @Nullable String defaultDetail, @Nullable Object[] detailArgs, @Nullable ThrowableProblem cause, @Nullable Map<String, Object> parameters) {
        super(defaultDetail, cause);
        Assert.notNull((Object)status, (String)"'status' must not be null");
        this.status = status;
        this.errorKey = errorKey;
        this.problem = problem;
        this.defaultDetail = defaultDetail;
        this.detailArgs = detailArgs;
        this.cause = cause;
        this.parameters = parameters;
    }

    public static ApplicationProblem of(HttpStatus status, String errorKey, @Nullable String defaultDetail, @Nullable Object[] detailArgs, @Nullable ThrowableProblem cause, @Nullable Map<String, Object> parameters) {
        Assert.hasText((String)errorKey, (String)"'errorKey' must not be null or empty");
        return new ApplicationProblem(status, null, errorKey, defaultDetail, detailArgs, cause, parameters);
    }

    public static ApplicationProblem of(HttpStatus status, String errorKey) {
        Assert.hasText((String)errorKey, (String)"'errorKey' must not be null or empty");
        return new ApplicationProblem(status, null, errorKey, null, null, null, null);
    }

    public static ApplicationProblem of(HttpStatus status, Problem problem) {
        Assert.notNull((Object)problem, (String)"'problem' must not be null");
        return new ApplicationProblem(status, problem, null, problem.getDetail(), null, null, null);
    }

    @Override
    public HttpStatus getStatus() {
        return this.status;
    }

    @Override
    public String getErrorKey() {
        return this.errorKey;
    }

    @Override
    public String getDefaultDetail() {
        return this.defaultDetail;
    }

    @Override
    public Object[] getDetailArgs() {
        return this.detailArgs;
    }

    @Override
    public ThrowableProblem getCause() {
        return this.cause;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public Problem getProblem() {
        return this.problem;
    }
}

