/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.http.MediaType;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

final class FallbackContentNegotiationStrategy
implements ContentNegotiationStrategy {
    private final List<MediaType> all = Collections.singletonList(MediaType.ALL);
    private final ContentNegotiationStrategy delegate;

    FallbackContentNegotiationStrategy(ContentNegotiationStrategy delegate) {
        this.delegate = delegate;
    }

    @Nonnull
    public List<MediaType> resolveMediaTypes(NativeWebRequest request) throws HttpMediaTypeNotAcceptableException {
        List mediaTypes = this.delegate.resolveMediaTypes(request);
        if (mediaTypes.isEmpty()) {
            return this.all;
        }
        return mediaTypes;
    }
}

