/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import com.ksoot.problem.core.DefaultProblem;
import com.ksoot.problem.core.ProblemUtils;
import com.ksoot.problem.core.ThrowableProblem;
import jakarta.annotation.Nullable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.builder.Builder;
import org.springframework.util.Assert;

public interface Problem {
    public String getCode();

    public String getTitle();

    public String getDetail();

    public ThrowableProblem getCause();

    default public Map<String, Object> getParameters() {
        return Collections.emptyMap();
    }

    public static String toString(Problem problem) {
        Stream<String> parts = Stream.concat(Stream.of(problem.getCode(), problem.getTitle(), problem.getDetail()), problem.getParameters().entrySet().stream().map((Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Ljava/util/Map$Entry;)Ljava/lang/String;)())).filter(Objects::nonNull);
        return problem.getCode() + "{" + parts.collect(Collectors.joining(", ")) + "}";
    }

    public static class ProblemBuilder
    implements DetailBuilder,
    CauseBuilder {
        private static final Set<String> RESERVED_PROPERTIES = new HashSet<String>(Arrays.asList("code", "title", "detail", "cause"));
        private String code;
        private String title;
        private String detail;
        private ThrowableProblem cause;
        private final Map<String, Object> parameters = new LinkedHashMap<String, Object>();

        ProblemBuilder(String code, String title) {
            this(code, title, null);
        }

        ProblemBuilder(String code, String title, String detail) {
            Assert.hasText((String)code, (String)"'code' must not be null or empty");
            Assert.hasText((String)title, (String)"'title' must not be null or empty");
            this.code = code;
            this.title = title;
            this.detail = detail;
        }

        @Override
        public CauseBuilder detail(String detail) {
            this.detail = detail;
            return this;
        }

        @Override
        public ParameterBuilder cause(@Nullable Throwable cause) {
            this.cause = Objects.nonNull(cause) ? ProblemUtils.toProblem(cause) : null;
            return this;
        }

        @Override
        public ParameterBuilder parameter(String key, Object value) {
            Assert.hasText((String)key, (String)"'key' must not be null or empty");
            Assert.isTrue((!RESERVED_PROPERTIES.contains(key) ? 1 : 0) != 0, (String)("Property " + key + " is reserved"));
            this.parameters.put(key, value);
            return this;
        }

        @Override
        public Builder<ThrowableProblem> parameters(@Nullable Map<String, Object> parameters) {
            if (MapUtils.isNotEmpty(parameters)) {
                parameters.entrySet().stream().forEach(entry -> this.parameter((String)entry.getKey(), entry.getValue()));
            }
            return this;
        }

        public ThrowableProblem build() {
            return new DefaultProblem(this.code, this.title, this.detail, this.cause, this.parameters);
        }
    }

    public static interface ParametersBuilder
    extends Builder<ThrowableProblem> {
        public Builder<ThrowableProblem> parameters(@Nullable Map<String, Object> var1);
    }

    public static interface ParameterBuilder
    extends ParametersBuilder {
        public ParameterBuilder parameter(String var1, Object var2);
    }

    public static interface CauseBuilder
    extends ParameterBuilder {
        public ParameterBuilder cause(@Nullable Throwable var1);
    }

    public static interface DetailBuilder {
        public CauseBuilder detail(String var1);
    }
}

