/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Map;
import org.springframework.http.HttpStatusCode;

final class HttpStatusDeserializer
extends JsonDeserializer<HttpStatusCode> {
    private final Map<Integer, HttpStatusCode> index;

    HttpStatusDeserializer(Map<Integer, HttpStatusCode> index) {
        this.index = index;
    }

    public HttpStatusCode deserialize(JsonParser json, DeserializationContext context) throws IOException {
        int statusCode = json.getIntValue();
        HttpStatusCode status = this.index.get(statusCode);
        return status;
    }
}

