/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.ksoot.problem.core.DefaultProblem;
import com.ksoot.problem.core.Exceptional;
import com.ksoot.problem.core.Problem;
import com.ksoot.problem.jackson.AbstractThrowableProblemMixIn;
import com.ksoot.problem.jackson.ExceptionalMixin;
import com.ksoot.problem.jackson.HttpMethodDeserializer;
import com.ksoot.problem.jackson.HttpMethodSerializer;
import com.ksoot.problem.jackson.HttpStatusDeserializer;
import com.ksoot.problem.jackson.HttpStatusSerializer;
import com.ksoot.problem.jackson.ProblemMixIn;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

public final class ProblemModule
extends Module {
    private final Map<Integer, HttpStatusCode> statuses;

    public ProblemModule() {
        this(HttpStatus.class);
    }

    @SafeVarargs
    public <E extends Enum<?>> ProblemModule(Class<? extends E> ... types) throws IllegalArgumentException {
        this(ProblemModule.buildIndex(types));
    }

    private ProblemModule(Map<Integer, HttpStatusCode> statuses) {
        this.statuses = statuses;
    }

    @SafeVarargs
    private static <E extends Enum<?>> Map<Integer, HttpStatusCode> buildIndex(Class<? extends E> ... types) {
        HashMap<Integer, HttpStatusCode> index = new HashMap<Integer, HttpStatusCode>();
        for (Class<E> clazz : types) {
            for (Enum status : (Enum[])clazz.getEnumConstants()) {
                if (((HttpStatus)status).getReasonPhrase().equalsIgnoreCase("Checkpoint")) continue;
                index.put(((HttpStatusCode)status).value(), (HttpStatusCode)status);
            }
        }
        return Collections.unmodifiableMap(index);
    }

    public String getModuleName() {
        return ProblemModule.class.getSimpleName();
    }

    public Version version() {
        return VersionUtil.versionFor(ProblemModule.class);
    }

    private Class<?> mixinClass() {
        return ExceptionalMixin.class;
    }

    public void setupModule(Module.SetupContext context) {
        SimpleModule module = new SimpleModule();
        module.setMixInAnnotation(Exceptional.class, this.mixinClass());
        module.setMixInAnnotation(DefaultProblem.class, AbstractThrowableProblemMixIn.class);
        module.setMixInAnnotation(Problem.class, ProblemMixIn.class);
        module.addSerializer(HttpStatusCode.class, (JsonSerializer)new HttpStatusSerializer());
        module.addDeserializer(HttpStatusCode.class, (JsonDeserializer)new HttpStatusDeserializer(this.statuses));
        module.addSerializer(HttpMethod.class, (JsonSerializer)new HttpMethodSerializer());
        module.addDeserializer(HttpMethod.class, (JsonDeserializer)new HttpMethodDeserializer());
        module.addSerializer(StackTraceElement.class, (JsonSerializer)new ToStringSerializer());
        module.setupModule(context);
    }
}

