/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice;

import com.ksoot.problem.core.ErrorResponseBuilder;
import com.ksoot.problem.core.Problem;
import com.ksoot.problem.core.ProblemUtils;
import com.ksoot.problem.core.Problems;
import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.config.ProblemBeanRegistry;
import com.ksoot.problem.spring.config.ProblemMessageProvider;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

public interface AdviceTrait<T, R> {
    public static final Logger logger = LoggerFactory.getLogger(AdviceTrait.class);

    default public Problem toProblem(Throwable throwable, String defaultErrorKey, HttpStatus defaultStatus) {
        String errorKey = ClassUtils.getName((Object)throwable);
        ProblemMessageSourceResolver statusResolver = ProblemMessageSourceResolver.of("status." + errorKey, defaultStatus.value());
        HttpStatus status = defaultStatus;
        try {
            String statusCode = ProblemMessageProvider.getMessage(statusResolver);
            status = HttpStatus.valueOf((String)statusCode);
        }
        catch (Exception statusCode) {
            // empty catch block
        }
        ProblemMessageSourceResolver defaultCodeResolver = ProblemMessageSourceResolver.of("code." + defaultErrorKey, status.value());
        ProblemMessageSourceResolver defaultTitleResolver = ProblemMessageSourceResolver.of("title." + defaultErrorKey, status.getReasonPhrase());
        ProblemMessageSourceResolver defaultDetailResolver = ProblemMessageSourceResolver.of("detail." + defaultErrorKey, throwable.getMessage());
        ProblemMessageSourceResolver codeResolver = ProblemMessageSourceResolver.of("code." + errorKey, ProblemMessageProvider.getMessage(defaultCodeResolver));
        ProblemMessageSourceResolver titleResolver = ProblemMessageSourceResolver.of("title." + errorKey, ProblemMessageProvider.getMessage(defaultTitleResolver));
        ProblemMessageSourceResolver detailResolver = ProblemMessageSourceResolver.of("detail." + errorKey, ProblemMessageProvider.getMessage(defaultDetailResolver));
        ThrowableProblem problem = this.toProblem(throwable, (MessageSourceResolvable)codeResolver, (MessageSourceResolvable)titleResolver, (MessageSourceResolvable)detailResolver, statusResolver);
        return problem;
    }

    default public ThrowableProblem toProblem(Throwable throwable) {
        HttpStatus status = HttpStatus.valueOf((int)ProblemUtils.resolveStatus(throwable).value());
        return this.toProblem(throwable, status);
    }

    default public ThrowableProblem toProblem(Throwable throwable, HttpStatus status) {
        return this.toProblem(throwable, status, throwable.getMessage());
    }

    default public ThrowableProblem toProblem(Throwable throwable, HttpStatus status, String detail) {
        return this.toProblem(throwable, ProblemUtils.statusCode((HttpStatusCode)status), status.getReasonPhrase(), detail);
    }

    default public ThrowableProblem toProblem(Throwable throwable, String code, String title, String detail) {
        return this.toProblem(throwable, code, title, detail, new LinkedHashMap<String, Object>());
    }

    default public ThrowableProblem toProblem(Throwable throwable, String code, String title, String detail, Map<String, Object> parameters) {
        ThrowableProblem problem = this.buildProblem(throwable, code, title, detail, parameters);
        StackTraceElement[] stackTrace = ProblemUtils.createStackTrace(throwable);
        problem.setStackTrace(stackTrace);
        return problem;
    }

    default public ThrowableProblem toProblem(Throwable throwable, HttpStatus status, MessageSourceResolvable detailResolver) {
        return this.toProblem(throwable, ProblemUtils.statusCode((HttpStatusCode)status), status.getReasonPhrase(), detailResolver);
    }

    default public ThrowableProblem toProblem(Throwable throwable, String code, String title, MessageSourceResolvable detailResolver) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
            parameters.put("detailResolver", detailResolver);
        }
        return this.toProblem(throwable, code, title, ProblemMessageProvider.getMessage(detailResolver), parameters);
    }

    default public ThrowableProblem toProblem(Throwable throwable, String code, MessageSourceResolvable titleResolver, MessageSourceResolvable detailResolver) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
            parameters.put("titleResolver", titleResolver);
            parameters.put("detailResolver", detailResolver);
        }
        return this.toProblem(throwable, code, ProblemMessageProvider.getMessage(titleResolver), ProblemMessageProvider.getMessage(detailResolver), parameters);
    }

    default public ThrowableProblem toProblem(Throwable throwable, MessageSourceResolvable codeResolver, MessageSourceResolvable titleResolver, MessageSourceResolvable detailResolver) {
        return this.toProblem(throwable, codeResolver, titleResolver, detailResolver, new LinkedHashMap<String, Object>());
    }

    default public ThrowableProblem toProblem(Throwable throwable, MessageSourceResolvable codeResolver, MessageSourceResolvable titleResolver, MessageSourceResolvable detailResolver, Map<String, Object> parameters) {
        if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
            parameters.put("codeResolver", codeResolver);
            parameters.put("titleResolver", titleResolver);
            parameters.put("detailResolver", detailResolver);
        }
        return this.toProblem(throwable, ProblemMessageProvider.getMessage(codeResolver), ProblemMessageProvider.getMessage(titleResolver), ProblemMessageProvider.getMessage(detailResolver), parameters);
    }

    default public ThrowableProblem toProblem(Throwable throwable, MessageSourceResolvable codeResolver, MessageSourceResolvable titleResolver, MessageSourceResolvable detailResolver, ProblemMessageSourceResolver statusResolver) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
            parameters.put("codeResolver", codeResolver);
            parameters.put("titleResolver", titleResolver);
            parameters.put("detailResolver", detailResolver);
            parameters.put("statusResolver", statusResolver);
        }
        return this.toProblem(throwable, ProblemMessageProvider.getMessage(codeResolver), ProblemMessageProvider.getMessage(titleResolver), ProblemMessageProvider.getMessage(detailResolver), parameters);
    }

    default public Problem toProblem(Throwable exception, HttpStatus status, String errorKey, String defaultDetail, Object[] detailArgs, Map<String, Object> parameters) {
        String codeCode = "code." + errorKey;
        String titleCode = "title." + errorKey;
        String detailCode = "detail." + errorKey;
        return this.toProblem(exception, (MessageSourceResolvable)ProblemMessageSourceResolver.of(codeCode, status.value()), (MessageSourceResolvable)ProblemMessageSourceResolver.of(titleCode, status.getReasonPhrase()), (MessageSourceResolvable)ProblemMessageSourceResolver.of(detailCode, Optional.ofNullable(defaultDetail).orElse(detailCode), detailArgs), Optional.ofNullable(parameters).orElse(Collections.emptyMap()));
    }

    default public ThrowableProblem buildProblem(Throwable throwable, String code, String title, String detail, Map<String, Object> parameters) {
        if (ProblemBeanRegistry.problemProperties().isStacktraceEnabled()) {
            StackTraceElement[] stackTrace = ProblemUtils.createStackTrace(throwable);
            parameters.put("statcktrace", stackTrace);
        }
        return (ThrowableProblem)Problems.newInstance(code, title, detail).cause(Optional.ofNullable(throwable.getCause()).filter(cause -> ProblemBeanRegistry.problemProperties().isCauseChainsEnabled()).map(this::toProblem).orElse(null)).parameters(Collections.unmodifiableMap(parameters)).build();
    }

    default public R toResponse(Throwable throwable, T request) {
        HttpStatus status = HttpStatus.valueOf((int)ProblemUtils.resolveStatus(throwable).value());
        return this.toResponse(throwable, request, status, this.toProblem(throwable));
    }

    default public R toResponse(Throwable throwable, T request, HttpStatus status) {
        return this.toResponse(throwable, request, status, new HttpHeaders());
    }

    default public R toResponse(Throwable throwable, T request, HttpStatus status, HttpHeaders headers) {
        return this.buildResponse(throwable, request, status, headers, this.toProblem(throwable, status));
    }

    default public R toResponse(Throwable throwable, T request, HttpStatus status, Problem problem) {
        return this.buildResponse(throwable, request, status, new HttpHeaders(), problem);
    }

    default public R buildResponse(Throwable throwable, T request, HttpStatus status, HttpHeaders headers, Problem problem) {
        this.log(throwable, status);
        return this.errorResponseBuilder().buildResponse(throwable, request, status, headers, problem);
    }

    default public void log(Throwable throwable, HttpStatus status) {
        logger.error(status.getReasonPhrase(), throwable);
    }

    default public ErrorResponseBuilder<T, R> errorResponseBuilder() {
        return ProblemBeanRegistry.errorResponseBuilder();
    }
}

