/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.application;

import com.google.common.collect.Lists;
import com.ksoot.problem.core.MultiProblem;
import com.ksoot.problem.core.Problem;
import com.ksoot.problem.core.ProblemSupport;
import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface ApplicationMultiProblemAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleMultiProblem(MultiProblem exception, T request) {
        ArrayList problems = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(exception.getErrors())) {
            problems.addAll(exception.getErrors().stream().map(ex -> {
                if (ex instanceof Problem) {
                    Problem problem = (Problem)ex;
                    return problem;
                }
                if (ex instanceof ProblemSupport) {
                    ProblemSupport problemSupport = (ProblemSupport)ex;
                    if (Objects.nonNull(problemSupport.getProblem())) {
                        return problemSupport.getProblem();
                    }
                    String errorKey = problemSupport.getErrorKey();
                    String detailCode = "detail." + errorKey;
                    return this.toProblem((Throwable)ex, problemSupport.getStatus(), errorKey, Optional.ofNullable(problemSupport.getDefaultDetail()).orElse(detailCode), problemSupport.getDetailArgs(), Optional.ofNullable(problemSupport.getParameters()).orElse(Collections.emptyMap()));
                }
                if (ex instanceof Throwable) {
                    Throwable throwable = (Throwable)ex;
                    return this.toProblem(throwable, "internal.server.error", HttpStatus.INTERNAL_SERVER_ERROR);
                }
                throw new IllegalStateException("MultiProblem contain illegal instance: " + String.valueOf(ex));
            }).toList());
        }
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(problems.size() + 5);
        parameters.put("errors", problems);
        HttpStatus status = exception.getStatus();
        ProblemMessageSourceResolver codeResolver = ProblemMessageSourceResolver.of("code.multiple.errors", status.value());
        ProblemMessageSourceResolver titleResolver = ProblemMessageSourceResolver.of("title.multiple.errors", status.getReasonPhrase());
        ProblemMessageSourceResolver detailResolver = ProblemMessageSourceResolver.of("detail.multiple.errors", exception.getMessage());
        ThrowableProblem problem = this.toProblem((Throwable)exception, (MessageSourceResolvable)codeResolver, (MessageSourceResolvable)titleResolver, (MessageSourceResolvable)detailResolver, parameters);
        return this.toResponse((Throwable)exception, request, exception.getStatus(), problem);
    }
}

