/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.http;

import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface HttpRequestMethodNotSupportedAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException exception, T request) {
        Object[] methods = exception.getSupportedMethods();
        String requestedMethod = exception.getMethod();
        String allowedMethods = ArrayUtils.isEmpty((Object[])methods) ? "None" : String.join((CharSequence)",", (CharSequence[])methods);
        ThrowableProblem problem = this.toProblem((Throwable)exception, HttpStatus.METHOD_NOT_ALLOWED, ProblemMessageSourceResolver.of("detail.request.method.not.supported", "Requested Method: {0} not allowed, allowed methods are: {1}", new Object[]{requestedMethod, allowedMethods}));
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Objects.requireNonNull(exception.getSupportedHttpMethods()));
        return this.buildResponse((Throwable)exception, request, HttpStatus.METHOD_NOT_ALLOWED, headers, problem);
    }
}

