/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.http;

import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.server.MethodNotAllowedException;

public interface MethodNotAllowedAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleMethodNotAllowedException(MethodNotAllowedException exception, T request) {
        Set methods = exception.getSupportedMethods();
        String requestedMethod = exception.getHttpMethod();
        String allowedMethods = CollectionUtils.isEmpty((Collection)methods) ? "None" : methods.stream().map(HttpMethod::name).collect(Collectors.joining(","));
        ThrowableProblem problem = this.toProblem((Throwable)exception, HttpStatus.METHOD_NOT_ALLOWED, ProblemMessageSourceResolver.of("detail.method.not.allowed", "Requested Method: {0} not allowed, allowed methods are: {1}", new Object[]{requestedMethod, allowedMethods}));
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Objects.requireNonNull(methods));
        return this.buildResponse((Throwable)exception, request, HttpStatus.METHOD_NOT_ALLOWED, headers, problem);
    }
}

