/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.io;

import com.google.common.base.CharMatcher;
import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.buffer.DataBufferLimitException;
import org.springframework.http.HttpStatus;
import org.springframework.util.unit.DataSize;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface DataBufferLimitExceptionAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleDataBufferLimitException(DataBufferLimitException exception, T request) {
        String errorKey = ClassUtils.getName((Object)exception);
        String defaultMessage = exception.getMessage();
        long bytes = -1L;
        try {
            String byteSizeString = CharMatcher.inRange((char)'0', (char)'9').retainFrom((CharSequence)defaultMessage);
            bytes = StringUtils.isNotBlank((CharSequence)byteSizeString) ? Long.parseLong(byteSizeString) : bytes;
        }
        catch (Exception byteSizeString) {
            // empty catch block
        }
        String maxFileSizeAllowed = bytes != -1L ? DataSize.ofBytes((long)bytes).toString() : "UNKNOWN";
        String detailCode = "detail." + errorKey;
        ThrowableProblem problem = this.toProblem((Throwable)exception, HttpStatus.BAD_REQUEST, ProblemMessageSourceResolver.of(detailCode, defaultMessage, new Object[]{maxFileSizeAllowed}));
        return this.toResponse((Throwable)exception, request, HttpStatus.BAD_REQUEST, problem);
    }
}

