/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.validation;

import com.ksoot.problem.spring.advice.validation.BaseValidationAdviceTrait;
import com.ksoot.problem.spring.advice.validation.ViolationVM;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public interface BaseBindingResultHandlingAdviceTrait<T, R>
extends BaseValidationAdviceTrait<T, R> {
    default public List<ViolationVM> handleBindingResult(BindingResult bindingResult, Throwable exception) {
        Stream<ViolationVM> fieldErrors = bindingResult.getFieldErrors().stream().map(fieldError -> this.handleFieldError((FieldError)fieldError, exception));
        Stream<ViolationVM> globalErrors = bindingResult.getGlobalErrors().stream().map(objectError -> this.handleObjectError((ObjectError)objectError, exception));
        return Stream.concat(fieldErrors, globalErrors).toList();
    }

    default public ViolationVM handleFieldError(FieldError fieldError, Throwable exception) {
        HttpStatus status = this.defaultConstraintViolationStatus();
        ProblemMessageSourceResolver codeResolver = ProblemMessageSourceResolver.of("code.constraint.violation", fieldError, status.value());
        ProblemMessageSourceResolver messageResolver = ProblemMessageSourceResolver.of("detail.constraint.violation", fieldError);
        return this.createViolation(codeResolver, messageResolver, fieldError.getField());
    }

    default public ViolationVM handleObjectError(ObjectError objectError, Throwable exception) {
        HttpStatus status = this.defaultConstraintViolationStatus();
        ProblemMessageSourceResolver codeResolver = ProblemMessageSourceResolver.of("code.constraint.violation", objectError, status.value());
        ProblemMessageSourceResolver messageResolver = ProblemMessageSourceResolver.of("detail.constraint.violation", objectError);
        return this.createViolation(codeResolver, messageResolver, objectError.getObjectName());
    }
}

