/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import com.ksoot.problem.core.FallbackContentNegotiationStrategy;
import com.ksoot.problem.core.MediaTypes;
import com.ksoot.problem.core.Problem;
import com.ksoot.problem.spring.config.ProblemBeanRegistry;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ProblemDetail;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

public interface ErrorResponseBuilder<T, R> {
    public static final ContentNegotiationStrategy DEFAULT_CONTENT_NEGOTIATION_STRATEGY = new FallbackContentNegotiationStrategy((ContentNegotiationStrategy)new HeaderContentNegotiationStrategy());

    public static Optional<MediaType> getProblemMediaType(List<MediaType> mediaTypes) {
        for (MediaType mediaType : mediaTypes) {
            if (mediaType.includes(MediaType.APPLICATION_JSON) || mediaType.includes(MediaTypes.PROBLEM)) {
                return Optional.of(MediaTypes.PROBLEM);
            }
            if (!mediaType.includes(MediaTypes.X_PROBLEM)) continue;
            return Optional.of(MediaTypes.X_PROBLEM);
        }
        return Optional.empty();
    }

    public R buildResponse(Throwable var1, T var2, HttpStatus var3, HttpHeaders var4, Problem var5);

    default public ProblemDetail createProblemDetail(T request, HttpStatus status, Problem problem) {
        ProblemDetail problemDetail = ProblemDetail.forStatusAndDetail((HttpStatusCode)status, (String)problem.getDetail());
        problemDetail.setTitle(problem.getTitle());
        problemDetail.setInstance(this.requestUri(request));
        if (StringUtils.isNotBlank((CharSequence)ProblemBeanRegistry.problemProperties().getTypeUrl())) {
            URI type = URI.create(ProblemBeanRegistry.problemProperties().getTypeUrl() + "#" + problem.getCode());
            problemDetail.setType(type);
        }
        problemDetail.setProperty("method", (Object)this.requestMethod(request));
        problemDetail.setProperty("timestamp", (Object)OffsetDateTime.now());
        problemDetail.setProperty("code", (Object)problem.getCode());
        if (MapUtils.isNotEmpty(problem.getParameters())) {
            problem.getParameters().forEach((k, v) -> problemDetail.setProperty(k, v));
        }
        if (Objects.nonNull(problem.getCause())) {
            problemDetail.setProperty("cause", (Object)problem.getCause());
        }
        return problemDetail;
    }

    default public URI requestUri(T request) {
        throw new UnsupportedOperationException("Method need to be implemented in implementation class");
    }

    default public HttpMethod requestMethod(T request) {
        throw new UnsupportedOperationException("Method need to be implemented in implementation class");
    }
}

