/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import com.ksoot.problem.core.Lists;
import com.ksoot.problem.core.Problems;
import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.config.ProblemBeanRegistry;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.ResponseStatus;

public final class ProblemUtils {
    public static String statusCode(HttpStatusCode httpStatus) {
        return String.valueOf(httpStatus.value());
    }

    public static ThrowableProblem toProblem(Throwable throwable) {
        HttpStatus status = ProblemUtils.resolveStatus(throwable);
        ThrowableProblem problem = (ThrowableProblem)Problems.newInstance(status).detail(throwable.getMessage()).build();
        problem.setStackTrace(ProblemUtils.createStackTrace(throwable));
        return problem;
    }

    public static HttpStatus resolveStatus(Throwable throwable) {
        return Optional.ofNullable(ProblemUtils.resolveResponseStatus(throwable)).map(ResponseStatus::value).orElse(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static ResponseStatus resolveResponseStatus(Throwable type) {
        ResponseStatus candidate = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(type.getClass(), ResponseStatus.class);
        return candidate == null && type.getCause() != null ? ProblemUtils.resolveResponseStatus(type.getCause()) : candidate;
    }

    public static StackTraceElement[] createStackTrace(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause == null || !ProblemBeanRegistry.problemProperties().isCauseChainsEnabled()) {
            return throwable.getStackTrace();
        }
        StackTraceElement[] next = cause.getStackTrace();
        StackTraceElement[] current = throwable.getStackTrace();
        int length = current.length - Lists.lengthOfTrailingPartialSubList(Arrays.asList(next), Arrays.asList(current));
        StackTraceElement[] stackTrace = new StackTraceElement[length];
        System.arraycopy(current, 0, stackTrace, 0, length);
        return stackTrace;
    }

    public static String getStackTrace(Throwable exception) {
        String stacktrace = ExceptionUtils.getStackTrace((Throwable)exception);
        StringBuilder escapedStacktrace = new StringBuilder(stacktrace.length() + 100);
        StringCharacterIterator scitr = new StringCharacterIterator(stacktrace);
        char current = scitr.first();
        Object lastAppend = null;
        while (current != '\uffff') {
            if (current == '\t' || current == '\r' || current == '\n') {
                if (!" ".equals(lastAppend)) {
                    escapedStacktrace.append(" ");
                    lastAppend = " ";
                }
            } else {
                escapedStacktrace.append(current);
                lastAppend = "" + current;
            }
            current = scitr.next();
        }
        return escapedStacktrace.toString();
    }

    private ProblemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

