/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import com.ksoot.problem.core.ApplicationException;
import com.ksoot.problem.core.ApplicationProblem;
import com.ksoot.problem.core.ErrorType;
import com.ksoot.problem.core.MultiProblem;
import com.ksoot.problem.core.Problem;
import com.ksoot.problem.core.ProblemUtils;
import com.ksoot.problem.core.ThrowableProblem;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public final class Problems {
    public static Problem.DetailBuilder newInstance(HttpStatus status) {
        return new Problem.ProblemBuilder(String.valueOf(status.value()), status.getReasonPhrase());
    }

    public static Problem.CauseBuilder newInstance(String code, String title, String detail) {
        return new Problem.ProblemBuilder(code, title, detail);
    }

    public static DefaultDetailBuilder newInstance(String errorKey) {
        return new Builder(errorKey);
    }

    public static DetailArgsBuilder newInstance(ErrorType errorType) {
        return new Builder(errorType.getErrorKey(), errorType.getDefaultDetail(), errorType.getStatus());
    }

    public static ApplicationProblem throwAble(HttpStatus status, Problem problem) {
        return ApplicationProblem.of(status, problem);
    }

    public static ApplicationException throwAbleChecked(HttpStatus status, Problem problem) {
        Assert.notNull((Object)problem, (String)"'problem' must not be null");
        return ApplicationException.of(status, problem);
    }

    public static MultiProblem ofExceptions(HttpStatus status, List<Throwable> exceptions) {
        return MultiProblem.ofExceptions(status, exceptions);
    }

    public static MultiProblem ofExceptions(HttpStatus status, Throwable ... exceptions) {
        Assert.isTrue((boolean)ArrayUtils.isNotEmpty((Object[])exceptions), (String)"'exceptions' must not be null or empty");
        Assert.noNullElements((Object[])exceptions, (String)"'exceptions' must not contain null");
        return MultiProblem.ofExceptions(status, Arrays.asList(exceptions));
    }

    public static MultiProblem of(HttpStatus status, List<Problem> problems) {
        Assert.notNull((Object)status, (String)"'status' must not be null");
        return MultiProblem.ofProblems(status, problems);
    }

    public static MultiProblem of(HttpStatus status, Problem ... problems) {
        Assert.isTrue((boolean)ArrayUtils.isNotEmpty((Object[])problems), (String)"'problems' must not be null or empty");
        Assert.noNullElements((Object[])problems, (String)"'problems' must not contain null");
        return MultiProblem.ofProblems(status, Arrays.asList(problems));
    }

    public static ApplicationProblem notFound() {
        return Problems.newInstance("not.found").throwAble(HttpStatus.NOT_FOUND);
    }

    public static ApplicationProblem internalServerError() {
        return Problems.newInstance("internal.server.error").throwAble(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private Problems() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Builder
    implements DefaultDetailBuilder {
        private static final Set<String> RESERVED_PROPERTIES = new HashSet<String>(Arrays.asList("code", "title", "detail", "cause", "codeResolver", "titleResolver", "detailResolver"));
        private String errorKey;
        private String defaultDetail;
        private HttpStatus status;
        private Object[] detailArgs;
        private ThrowableProblem cause;
        private Map<String, Object> parameters = new LinkedHashMap<String, Object>(4);

        Builder(String errorKey) {
            this.errorKey = errorKey;
        }

        Builder(String errorKey, String defaultDetail, HttpStatus status) {
            this.errorKey = errorKey;
            this.defaultDetail = defaultDetail;
            this.status = status;
        }

        @Override
        public DetailArgsBuilder defaultDetail(@Nullable String defaultDetail) {
            this.defaultDetail = defaultDetail;
            return this;
        }

        @Override
        public CauseBuilder detailArgs(Object ... detailArgs) {
            this.detailArgs = detailArgs;
            return this;
        }

        @Override
        public ParameterBuilder cause(@Nullable Throwable cause) {
            this.cause = cause != null ? ProblemUtils.toProblem(cause) : null;
            return this;
        }

        @Override
        public ParameterBuilder parameter(String key, Object value) {
            Assert.hasLength((String)key, (String)"'key' must not be null or empty");
            Assert.isTrue((!RESERVED_PROPERTIES.contains(key) ? 1 : 0) != 0, (String)("Property " + key + " is reserved"));
            this.parameters.put(key, value);
            return this;
        }

        @Override
        public ProblemBuildable parameters(@Nullable Map<String, Object> parameters) {
            if (MapUtils.isNotEmpty(parameters)) {
                parameters.entrySet().stream().forEach(entry -> this.parameter((String)entry.getKey(), entry.getValue()));
            }
            return this;
        }

        @Override
        public ApplicationProblem throwAble() {
            return ApplicationProblem.of(Optional.ofNullable(this.status).orElse(HttpStatus.INTERNAL_SERVER_ERROR), this.errorKey, this.defaultDetail, this.detailArgs, this.cause, this.parameters);
        }

        @Override
        public ApplicationProblem throwAble(HttpStatus status) {
            return ApplicationProblem.of(status, this.errorKey, this.defaultDetail, this.detailArgs, this.cause, this.parameters);
        }

        @Override
        public ApplicationException throwAbleChecked() {
            return ApplicationException.of(Optional.ofNullable(this.status).orElse(HttpStatus.INTERNAL_SERVER_ERROR), this.errorKey, this.defaultDetail, this.detailArgs, this.cause, this.parameters);
        }

        @Override
        public ApplicationException throwAbleChecked(HttpStatus status) {
            return ApplicationException.of(status, this.errorKey, this.defaultDetail, this.detailArgs, this.cause, this.parameters);
        }
    }

    public static interface DefaultDetailBuilder
    extends DetailArgsBuilder {
        public DetailArgsBuilder defaultDetail(@Nullable String var1);
    }

    public static interface ProblemBuildable {
        public ApplicationProblem throwAble(HttpStatus var1);

        public ApplicationProblem throwAble();

        public ApplicationException throwAbleChecked(HttpStatus var1);

        public ApplicationException throwAbleChecked();
    }

    public static interface ParametersBuilder
    extends ProblemBuildable {
        public ProblemBuildable parameters(@Nullable Map<String, Object> var1);
    }

    public static interface ParameterBuilder
    extends ParametersBuilder {
        public ParameterBuilder parameter(String var1, Object var2);
    }

    public static interface CauseBuilder
    extends ParameterBuilder {
        public ParameterBuilder cause(@Nullable Throwable var1);
    }

    public static interface DetailArgsBuilder
    extends CauseBuilder {
        public CauseBuilder detailArgs(Object ... var1);
    }
}

