/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import com.ksoot.problem.core.Exceptional;
import com.ksoot.problem.core.Problem;
import com.ksoot.problem.core.StackTraceProcessor;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ThrowableProblem
extends RuntimeException
implements Problem,
Exceptional {
    private static final long serialVersionUID = 2893667887362253159L;

    protected ThrowableProblem() {
        this((ThrowableProblem)null);
    }

    protected ThrowableProblem(@Nullable ThrowableProblem cause) {
        super(cause);
        Collection<StackTraceElement> stackTrace = StackTraceProcessor.COMPOUND.process(Arrays.asList(this.getStackTrace()));
        this.setStackTrace(stackTrace.toArray(new StackTraceElement[0]));
    }

    @Override
    public String getDetail() {
        return Stream.of(this.getCode(), this.getTitle()).filter(Objects::nonNull).collect(Collectors.joining(": "));
    }

    @Override
    public ThrowableProblem getCause() {
        return (ThrowableProblem)super.getCause();
    }

    @Override
    public String toString() {
        return Problem.toString(this);
    }
}

