/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import com.ksoot.problem.core.Problem;
import com.ksoot.problem.core.ProblemSupport;
import com.ksoot.problem.core.ProblemUtils;
import com.ksoot.problem.core.ThrowableProblem;
import jakarta.annotation.Nullable;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public final class ApplicationException
extends Exception
implements ProblemSupport {
    private final HttpStatus status;
    private final String errorKey;
    private final String defaultDetail;
    private final Object[] detailArgs;
    private final ThrowableProblem cause;
    private final Map<String, Object> parameters;
    private final Problem problem;

    private ApplicationException(String message, HttpStatus status, Problem problem, String errorKey, @Nullable String defaultDetail, @Nullable Object[] detailArgs, @Nullable ThrowableProblem cause, @Nullable Map<String, Object> parameters) {
        super(message, cause);
        this.status = status;
        this.errorKey = errorKey;
        this.problem = problem;
        this.defaultDetail = defaultDetail;
        this.detailArgs = detailArgs;
        this.cause = cause;
        this.parameters = parameters;
    }

    public static ApplicationException of(HttpStatus status, String errorKey, @Nullable String defaultDetail, @Nullable Object[] detailArgs, @Nullable ThrowableProblem cause, @Nullable Map<String, Object> parameters) {
        Assert.hasText((String)errorKey, (String)"'errorKey' must not be null or empty");
        return new ApplicationException(ProblemUtils.toMessage(errorKey, defaultDetail, null, cause), status, null, errorKey, defaultDetail, detailArgs, cause, parameters);
    }

    public static ApplicationException of(HttpStatus status, Problem problem) {
        Assert.notNull((Object)problem, (String)"'problem' must not be null");
        return new ApplicationException(ProblemUtils.toMessage(null, null, problem, null), status, problem, null, null, null, null, null);
    }

    @Override
    @Generated
    public HttpStatus getStatus() {
        return this.status;
    }

    @Override
    @Generated
    public String getErrorKey() {
        return this.errorKey;
    }

    @Override
    @Generated
    public String getDefaultDetail() {
        return this.defaultDetail;
    }

    @Override
    @Generated
    public Object[] getDetailArgs() {
        return this.detailArgs;
    }

    @Override
    @Generated
    public ThrowableProblem getCause() {
        return this.cause;
    }

    @Override
    @Generated
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    @Generated
    public Problem getProblem() {
        return this.problem;
    }
}

