/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import com.ksoot.problem.core.Problem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class MultiProblem
extends RuntimeException {
    private final HttpStatus status;
    private final List<Object> errors;

    private MultiProblem(HttpStatus status, List<Problem> problems) {
        super(status.getReasonPhrase());
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(problems), (String)"'problems' must not be null or empty");
        Assert.noNullElements(problems, (String)"'problems' must not contain null");
        this.status = status;
        this.errors = new ArrayList<Problem>(problems);
    }

    private MultiProblem(List<Throwable> exceptions, HttpStatus status) {
        super(status.getReasonPhrase());
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(exceptions), (String)"'exceptions' must not be null or empty");
        Assert.noNullElements(exceptions, (String)"'exceptions' must not contain null");
        this.status = status;
        this.errors = new ArrayList<Throwable>(exceptions);
    }

    public static MultiProblem ofExceptions(HttpStatus status, List<Throwable> exceptions) {
        Assert.notNull((Object)status, (String)"'status' must not be null");
        return new MultiProblem(exceptions, status);
    }

    public static MultiProblem ofExceptions(List<Throwable> exceptions) {
        return MultiProblem.ofExceptions(HttpStatus.MULTI_STATUS, exceptions);
    }

    public static MultiProblem ofProblems(HttpStatus status, List<Problem> problems) {
        Assert.notNull((Object)status, (String)"'status' must not be null");
        return new MultiProblem(status, problems);
    }

    public static MultiProblem ofProblems(List<Problem> problems) {
        return MultiProblem.ofProblems(HttpStatus.MULTI_STATUS, problems);
    }

    public MultiProblem add(Throwable exception) {
        Assert.notNull((Object)exception, (String)"'exception' must not be null");
        this.errors.add(exception);
        return this;
    }

    public MultiProblem add(Problem problem) {
        Assert.notNull((Object)problem, (String)"'problem' must not be null");
        this.errors.add(problem);
        return this;
    }

    public List<Object> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    @Generated
    public HttpStatus getStatus() {
        return this.status;
    }
}

