/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.application;

import com.ksoot.problem.core.ApplicationProblem;
import com.ksoot.problem.core.Problem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface ApplicationProblemAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleApplicationProblem(ApplicationProblem exception, T request) {
        HttpStatus status = exception.getStatus();
        if (StringUtils.isNotBlank((CharSequence)exception.getErrorKey())) {
            String errorKey = exception.getErrorKey();
            String detailCode = "detail." + errorKey;
            Problem problem = this.toProblem(exception, exception.getStatus(), errorKey, Optional.ofNullable(exception.getDefaultDetail()).orElse(detailCode), exception.getDetailArgs(), Optional.ofNullable(exception.getParameters()).orElse(Collections.emptyMap()));
            return this.toResponse((Throwable)exception, request, status, problem);
        }
        return this.toResponse((Throwable)exception, request, exception.getStatus(), exception.getProblem());
    }
}

