/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.dao;

import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.dao.BaseDataIntegrityAdvice;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface DuplicateKeyExceptionAdviceTrait<T, R>
extends BaseDataIntegrityAdvice<T, R> {
    @ExceptionHandler
    default public R handleDuplicateKeyException(DuplicateKeyException exception, T request) {
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        String exceptionMessage = exception.getMostSpecificCause().getMessage().trim();
        String constraintName = this.resolveConstraintName(exceptionMessage);
        String codeCode = "code.data.integrity.violation." + constraintName;
        String titleCode = "title.data.integrity.violation." + constraintName;
        String messageCode = "detail.data.integrity.violation." + constraintName;
        ThrowableProblem problem = this.toProblem((Throwable)exception, ProblemMessageSourceResolver.of(codeCode, status.value()), (MessageSourceResolvable)ProblemMessageSourceResolver.of(titleCode, status.getReasonPhrase()), (MessageSourceResolvable)ProblemMessageSourceResolver.of(messageCode, "Database constraints violated"));
        return this.toResponse((Throwable)exception, request, status, problem);
    }
}

