/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.io;

import com.google.common.base.CharMatcher;
import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.impl.FileSizeLimitExceededException;
import org.springframework.http.HttpStatus;
import org.springframework.util.unit.DataSize;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

public interface MaxUploadSizeExceededExceptionAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleMaxUploadSizeExceededException(MaxUploadSizeExceededException exception, T request) {
        Object byteSizeString2;
        IllegalStateException e;
        Throwable throwable;
        String errorKey = ClassUtils.getName((Object)exception);
        String defaultMessage = exception.getMessage();
        long bytes = exception.getMaxUploadSize();
        if (bytes == -1L && (throwable = exception.getCause()) instanceof IllegalStateException) {
            e = (IllegalStateException)throwable;
            try {
                defaultMessage = e.getMessage();
                byteSizeString2 = defaultMessage.substring(defaultMessage.lastIndexOf("(") + 1, defaultMessage.lastIndexOf(")"));
                bytes = StringUtils.isNotBlank((CharSequence)byteSizeString2) ? Long.parseLong((String)byteSizeString2) : bytes;
            }
            catch (Exception byteSizeString2) {
                // empty catch block
            }
        }
        if (bytes == -1L && (byteSizeString2 = exception.getMostSpecificCause()) instanceof FileSizeLimitExceededException) {
            e = (FileSizeLimitExceededException)byteSizeString2;
            try {
                defaultMessage = e.getMessage();
                byteSizeString2 = CharMatcher.inRange((char)'0', (char)'9').retainFrom((CharSequence)defaultMessage);
                bytes = StringUtils.isNotBlank((CharSequence)byteSizeString2) ? Long.parseLong((String)byteSizeString2) : bytes;
            }
            catch (Exception byteSizeString3) {
                // empty catch block
            }
        }
        String maxFileSizeAllowed = bytes != -1L ? DataSize.ofBytes((long)bytes).toString() : "UNKNOWN";
        String detailCode = "detail." + errorKey;
        ThrowableProblem problem = this.toProblem((Throwable)exception, HttpStatus.BAD_REQUEST, ProblemMessageSourceResolver.of(detailCode, defaultMessage, new Object[]{maxFileSizeAllowed}));
        return this.toResponse((Throwable)exception, request, HttpStatus.BAD_REQUEST, problem);
    }
}

