/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.routing;

import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.validation.BaseValidationAdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MissingRequestHeaderException;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface MissingRequestHeaderAdviceTrait<T, R>
extends BaseValidationAdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleMissingServletRequestParameter(MissingRequestHeaderException exception, T request) {
        String errorKey = exception.getParameter().getContainingClass().getSimpleName() + "." + exception.getParameter().getMethod().getName() + "." + exception.getHeaderName();
        String codeCode = "code.missing.request.header." + errorKey;
        String titleCode = "title.missing.request.header." + errorKey;
        String detailCode = "detail.missing.request.header." + errorKey;
        HttpStatus status = this.defaultConstraintViolationStatus();
        ThrowableProblem problem = this.toProblem((Throwable)exception, ProblemMessageSourceResolver.of(codeCode, status.value()), (MessageSourceResolvable)ProblemMessageSourceResolver.of(titleCode, status.getReasonPhrase()), (MessageSourceResolvable)ProblemMessageSourceResolver.of(detailCode, exception.getMessage()));
        return this.toResponse((Throwable)exception, request, status, problem);
    }
}

