/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.validation;

import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.validation.BaseValidationAdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.LinkedHashMap;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

public interface MethodArgumentTypeMismatchAdviceTrait<T, R>
extends BaseValidationAdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException exception, T request) {
        HttpStatus status = this.defaultConstraintViolationStatus();
        String parameterName = exception.getParameter().getParameterName();
        String errorKey = exception.getParameter().getContainingClass().getSimpleName() + "." + exception.getParameter().getMethod().getName() + "." + parameterName;
        String codeCode = "code.type.mismatch." + errorKey;
        String titleCode = "title.type.mismatch." + errorKey;
        String detailCode = "detail.type.mismatch." + errorKey;
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(4);
        parameters.put("propertyPath", parameterName);
        ThrowableProblem problem = this.toProblem((Throwable)exception, (MessageSourceResolvable)ProblemMessageSourceResolver.of(codeCode, status.value()), (MessageSourceResolvable)ProblemMessageSourceResolver.of(titleCode, status.getReasonPhrase()), (MessageSourceResolvable)ProblemMessageSourceResolver.of(detailCode, exception.getMostSpecificCause().toString()), parameters);
        return this.toResponse((Throwable)exception, request, status, problem);
    }
}

