/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.validation;

import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.springmvc.InvalidRequestException;
import com.atlassian.oai.validator.springmvc.InvalidResponseException;
import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.validation.BaseValidationAdviceTrait;
import com.ksoot.problem.spring.advice.validation.ViolationVM;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface OpenApiValidationAdviceTrait<T, R>
extends BaseValidationAdviceTrait<T, R> {
    @ExceptionHandler(value={InvalidRequestException.class})
    default public R handleInvalidRequest(InvalidRequestException exception, T request) {
        List<ViolationVM> violations = this.handleValidationReport(exception.getValidationReport(), (Throwable)exception);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(4);
        parameters.put("violations", violations);
        ThrowableProblem problem = this.toProblem((Throwable)exception, (MessageSourceResolvable)ProblemMessageSourceResolver.of("code.constraint.violation"), (MessageSourceResolvable)ProblemMessageSourceResolver.of("title.constraint.violation"), (MessageSourceResolvable)ProblemMessageSourceResolver.of("detail.constraint.violation", exception.getMessage()), parameters);
        return this.toResponse((Throwable)exception, request, this.defaultConstraintViolationStatus(), problem);
    }

    @ExceptionHandler
    default public R handleInvalidResponse(InvalidResponseException exception, T request) {
        List<ViolationVM> violations = this.handleValidationReport(exception.getValidationReport(), (Throwable)exception);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(4);
        parameters.put("violations", violations);
        ThrowableProblem problem = this.toProblem((Throwable)exception, (MessageSourceResolvable)ProblemMessageSourceResolver.of("code.constraint.violation"), (MessageSourceResolvable)ProblemMessageSourceResolver.of("title.constraint.violation"), (MessageSourceResolvable)ProblemMessageSourceResolver.of("detail.constraint.violation", exception.getMessage()), parameters);
        return this.toResponse((Throwable)exception, request, this.defaultConstraintViolationStatus(), problem);
    }

    default public List<ViolationVM> handleValidationReport(ValidationReport validationReport, Throwable exception) {
        return validationReport.getMessages().stream().filter(message -> message.getLevel() == ValidationReport.Level.ERROR).flatMap(message -> this.handleValidationReportMessage((ValidationReport.Message)message, exception).stream()).toList();
    }

    default public List<ViolationVM> handleValidationReportMessage(ValidationReport.Message message, Throwable exception) {
        HttpStatus status = this.defaultConstraintViolationStatus();
        String propertyPath = this.getOpenApiViolationObjectPath(message);
        List<String[]> errorPropertyKeys = this.deriveOpenApiValidationErrorKeys(message);
        return errorPropertyKeys.stream().map(propertyKeys -> {
            String[] codeCodes = (String[])Arrays.stream(propertyKeys).map(errorKey -> "code.openapi.violation." + errorKey).toArray(String[]::new);
            String[] messageCodes = (String[])Arrays.stream(propertyKeys).map(errorKey -> "detail.openapi.violation." + errorKey).toArray(String[]::new);
            ProblemMessageSourceResolver codeResolver = ProblemMessageSourceResolver.of(codeCodes, "" + status.value());
            ProblemMessageSourceResolver messageResolver = ProblemMessageSourceResolver.of(messageCodes, message.getMessage());
            return this.createViolation(codeResolver, messageResolver, propertyPath);
        }).toList();
    }

    default public String getOpenApiViolationObjectPath(ValidationReport.Message message) {
        return message.getContext().flatMap(ValidationReport.MessageContext::getParameter).map(Parameter::getName).orElseGet(() -> {
            String messageText = message.getMessage();
            try {
                int i1 = messageText.lastIndexOf("([");
                int j1 = messageText.lastIndexOf("])");
                int i2 = messageText.indexOf("'/");
                int j2 = messageText.indexOf("']");
                String objectPath = i2 == -1 || j2 == -1 ? "" : String.join((CharSequence)".", Arrays.stream(messageText.substring(i2 + 2, j2).split("/")).filter(part -> !StringUtils.isNumeric((CharSequence)part)).toList());
                return objectPath;
            }
            catch (Exception e) {
                return "";
            }
        });
    }

    default public List<String[]> deriveOpenApiValidationErrorKeys(ValidationReport.Message message) {
        String propertyKey = this.getOpenApiViolationObjectPath(message);
        Request.Method requestMethod = message.getContext().flatMap(ValidationReport.MessageContext::getRequestMethod).orElse(null);
        String requestPath = message.getContext().flatMap(ValidationReport.MessageContext::getRequestPath).orElse("").replaceAll("/", ".");
        if (StringUtils.isEmpty((CharSequence)propertyKey)) {
            if (requestMethod == null || requestMethod == Request.Method.GET) {
                ArrayList<String[]> errorKeys = new ArrayList<String[]>(1);
                errorKeys.add(new String[]{message.getKey()});
                return errorKeys;
            }
            String messageText = message.getMessage();
            try {
                String objectPath;
                int i1 = messageText.lastIndexOf("([");
                int j1 = messageText.lastIndexOf("])");
                int i2 = messageText.indexOf("'/");
                int j2 = messageText.indexOf("']");
                String string = objectPath = i2 == -1 || j2 == -1 ? "" : String.join((CharSequence)".", Arrays.stream(messageText.substring(i2 + 2, j2).split("/")).filter(part -> !StringUtils.isNumeric((CharSequence)part)).toList());
                if (i1 == -1) {
                    ArrayList<String[]> errorKeys = new ArrayList<String[]>(1);
                    errorKeys.add(new String[]{message.getKey() + requestPath + "." + requestMethod.name().toLowerCase() + "." + objectPath, message.getKey() + requestPath + "." + objectPath, message.getKey() + "." + objectPath, objectPath});
                    return errorKeys;
                }
                List properties = Arrays.asList(messageText.substring(i1 + 1, j1).replaceAll("\"", "").replace("[", "").replace("]", "").split(",")).stream().toList();
                Object objectPathPart = StringUtils.isNotBlank((CharSequence)objectPath) ? "." + objectPath + "." : ".";
                return properties.stream().map(arg_0 -> OpenApiValidationAdviceTrait.lambda$deriveOpenApiValidationErrorKeys$10(message, requestPath, requestMethod, (String)objectPathPart, arg_0)).toList();
            }
            catch (Exception e) {
                ArrayList<String[]> errorKeys = new ArrayList<String[]>(1);
                errorKeys.add(new String[]{message.getKey() + requestPath + "." + requestMethod.name().toLowerCase(), message.getKey() + requestPath, message.getKey()});
                return errorKeys;
            }
        }
        ArrayList<String[]> errorKeys = new ArrayList<String[]>(1);
        errorKeys.add(new String[]{message.getKey() + requestPath + "." + requestMethod.name().toLowerCase() + "." + propertyKey, message.getKey() + requestPath + "." + propertyKey, message.getKey() + "." + propertyKey});
        return errorKeys;
    }

    private static /* synthetic */ String[] lambda$deriveOpenApiValidationErrorKeys$10(ValidationReport.Message message, String requestPath, Request.Method requestMethod, String objectPathPart, String property) {
        return new String[]{message.getKey() + requestPath + "." + requestMethod.name().toLowerCase() + objectPathPart + property, message.getKey() + requestPath + objectPathPart + property, message.getKey() + objectPathPart + property};
    }
}

