/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.boot.autoconfigure.webflux;

import com.ksoot.problem.core.ErrorResponseBuilder;
import com.ksoot.problem.core.MediaTypes;
import com.ksoot.problem.core.Problem;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.accept.HeaderContentTypeResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SpringWebfluxErrorResponseBuilder
implements ErrorResponseBuilder<ServerWebExchange, Mono<ResponseEntity<ProblemDetail>>> {
    @Override
    public Mono<ResponseEntity<ProblemDetail>> buildResponse(Throwable throwable, ServerWebExchange request, HttpStatus status, HttpHeaders headers, Problem problem) {
        if (status == HttpStatus.INTERNAL_SERVER_ERROR) {
            request.getAttributes().put("jakarta.servlet.error.exception", throwable);
        }
        ProblemDetail problemDetail = this.createProblemDetail(request, status, problem);
        Optional<Mono> responseEntity = this.negotiate(request).map(contentType -> Mono.just((Object)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)status).headers(headers)).contentType(contentType).body((Object)problemDetail)));
        if (responseEntity.isPresent()) {
            return this.postProcess((Mono<ResponseEntity<ProblemDetail>>)responseEntity.get(), request);
        }
        return this.fallback(request, status, headers, problem);
    }

    Optional<MediaType> negotiate(ServerWebExchange request) {
        List mediaTypes = new HeaderContentTypeResolver().resolveMediaTypes(request);
        return ErrorResponseBuilder.getProblemMediaType(mediaTypes);
    }

    private Mono<ResponseEntity<ProblemDetail>> postProcess(Mono<ResponseEntity<ProblemDetail>> errorResponse, ServerWebExchange request) {
        return errorResponse;
    }

    private Mono<ResponseEntity<ProblemDetail>> fallback(ServerWebExchange request, HttpStatus status, HttpHeaders headers, Problem problem) {
        ProblemDetail problemDetail = this.createProblemDetail(request, status, problem);
        return Mono.just((Object)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)status).headers(headers)).contentType(MediaTypes.PROBLEM).body((Object)problemDetail));
    }

    @Override
    public URI requestUri(ServerWebExchange request) {
        return URI.create(request.getRequest().getPath().toString());
    }

    @Override
    public HttpMethod requestMethod(ServerWebExchange request) {
        return request.getRequest().getMethod();
    }
}

