/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.config;

import jakarta.validation.ConstraintViolation;
import java.io.Serializable;
import java.util.Arrays;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.lang.Nullable;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ProblemMessageSourceResolver
implements MessageSourceResolvable,
Serializable {
    private final String[] codes;
    @Nullable
    private String defaultMessage;
    @Nullable
    private Object[] arguments;

    private ProblemMessageSourceResolver(String[] codes, String defaultMessage, Object[] arguments) {
        this.codes = codes;
        this.defaultMessage = defaultMessage;
        this.arguments = arguments;
    }

    public static ProblemMessageSourceResolver of(String code) {
        return new ProblemMessageSourceResolver(new String[]{code}, null, null);
    }

    public static ProblemMessageSourceResolver of(String[] codes) {
        return new ProblemMessageSourceResolver(codes, null, null);
    }

    public static ProblemMessageSourceResolver of(String code, Object[] arguments) {
        return new ProblemMessageSourceResolver(new String[]{code}, null, arguments);
    }

    public static ProblemMessageSourceResolver of(String[] codes, Object[] arguments) {
        return new ProblemMessageSourceResolver(codes, null, arguments);
    }

    public static ProblemMessageSourceResolver of(String[] codes, String defaultMessage) {
        return new ProblemMessageSourceResolver(codes, defaultMessage, null);
    }

    public static ProblemMessageSourceResolver of(String[] codes, int status) {
        return new ProblemMessageSourceResolver(codes, String.valueOf(status), null);
    }

    public static ProblemMessageSourceResolver of(String code, String defaultMessage) {
        return new ProblemMessageSourceResolver(new String[]{code}, defaultMessage, null);
    }

    public static ProblemMessageSourceResolver of(String code, int statusCode) {
        return new ProblemMessageSourceResolver(new String[]{code}, String.valueOf(statusCode), null);
    }

    public static ProblemMessageSourceResolver of(String[] codes, String defaultMessage, Object[] arguments) {
        return new ProblemMessageSourceResolver(codes, defaultMessage, arguments);
    }

    public static ProblemMessageSourceResolver of(String code, String defaultMessage, Object[] arguments) {
        return new ProblemMessageSourceResolver(new String[]{code}, defaultMessage, arguments);
    }

    public static ProblemMessageSourceResolver of(String prefix, ObjectError objectError, String defaultMessage) {
        return ProblemMessageSourceResolver.of((String[])Arrays.stream(objectError.getCodes()).map(code -> prefix + "." + code).toArray(String[]::new), defaultMessage);
    }

    public static ProblemMessageSourceResolver of(String prefix, ObjectError objectError, int status) {
        return ProblemMessageSourceResolver.of((String[])Arrays.stream(objectError.getCodes()).map(code -> prefix + "." + code).toArray(String[]::new), "" + status);
    }

    public static ProblemMessageSourceResolver of(String prefix, ObjectError objectError) {
        return new ProblemMessageSourceResolver((String[])Arrays.stream(objectError.getCodes()).map(code -> prefix + "." + code).toArray(String[]::new), objectError.getDefaultMessage(), null);
    }

    public static ProblemMessageSourceResolver of(String prefix, FieldError fieldError) {
        return new ProblemMessageSourceResolver((String[])Arrays.stream(fieldError.getCodes()).map(code -> prefix + "." + code).toArray(String[]::new), fieldError.getDefaultMessage(), null);
    }

    public static ProblemMessageSourceResolver of(String prefix, FieldError fieldError, String defaultMessage) {
        return ProblemMessageSourceResolver.of((String[])Arrays.stream(fieldError.getCodes()).map(code -> prefix + "." + code).toArray(String[]::new), defaultMessage);
    }

    public static ProblemMessageSourceResolver of(String prefix, FieldError fieldError, int status) {
        return ProblemMessageSourceResolver.of((String[])Arrays.stream(fieldError.getCodes()).map(code -> prefix + "." + code).toArray(String[]::new), "" + status);
    }

    public static ProblemMessageSourceResolver of(String prefix, ConstraintViolation violation) {
        return ProblemMessageSourceResolver.of(prefix + "." + violation.getPropertyPath().toString(), violation.getMessage());
    }

    public static ProblemMessageSourceResolver of(String prefix, ConstraintViolation violation, String defaultMessage) {
        return ProblemMessageSourceResolver.of(prefix + "." + violation.getPropertyPath().toString(), defaultMessage);
    }

    public static ProblemMessageSourceResolver of(String prefix, ConstraintViolation violation, int status) {
        return ProblemMessageSourceResolver.of(prefix + "." + violation.getPropertyPath().toString(), "" + status);
    }

    public String[] getCodes() {
        return this.codes;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public Object[] getArguments() {
        return this.arguments;
    }
}

