/*
 * Decompiled with CFR 0.152.
 */
package org.paranora.mapstruct.processor;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public abstract class AbsProcessor
extends AbstractProcessor {
    protected Filer filer;
    protected Messager messager;
    protected Elements elementUtils;
    protected Types typesUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = processingEnvironment.getFiler();
        this.messager = processingEnvironment.getMessager();
        this.elementUtils = processingEnvironment.getElementUtils();
        this.typesUtils = processingEnvironment.getTypeUtils();
    }

    protected boolean isPresentAnnotation(TypeElement annotation, String presentAnnotationName) {
        return presentAnnotationName.contentEquals(annotation.getQualifiedName());
    }

    protected void processPresentAnnotation(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment, Class<?> annotationClass, Consumer<? super Element> consumer) {
        annotations.stream().filter(annotation -> this.isPresentAnnotation((TypeElement)annotation, annotationClass.getName())).filter(typeElement -> typeElement instanceof TypeElement).forEach(typeElement -> roundEnvironment.getElementsAnnotatedWith((TypeElement)typeElement).stream().forEach(element -> consumer.accept((Element)element)));
    }

    protected Optional<? extends AnnotationMirror> getAnnotationMirror(Element element, Class<?> clazz) {
        return element.getAnnotationMirrors().stream().filter(t -> t.getAnnotationType().toString().equalsIgnoreCase(clazz.getName())).findFirst();
    }

    protected AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String key) {
        Optional<Map.Entry> entry = annotationMirror.getElementValues().entrySet().stream().filter(es -> ((ExecutableElement)es.getKey()).getSimpleName().toString().equalsIgnoreCase(key)).findFirst();
        if (entry.isPresent()) {
            return (AnnotationValue)entry.get().getValue();
        }
        return null;
    }

    protected void processAnnotationMirrorFields(AnnotationMirror annotationMirror, Consumer<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> consumer) {
        annotationMirror.getElementValues().entrySet().stream().forEach(en -> consumer.accept((Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>)en));
    }

    protected void processClassFields(Element element, Consumer<? super VariableElement> consumer) {
        TypeMirror typeMirror = element.asType();
        ElementKind kind = element.getKind();
        this.print("typeMirror = " + typeMirror.toString());
        this.print("kind = " + kind.toString());
        if (ElementKind.CLASS == kind) {
            element.getEnclosedElements().stream().filter(e -> ElementKind.FIELD == e.getKind()).forEach(e -> consumer.accept((VariableElement)e));
        }
    }

    protected String prefix() {
        return "";
    }

    protected void print(String message) {
        this.print("%s", message);
    }

    protected void print(String format, Object ... message) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(this.prefix() + format, message));
    }

    public Filer getFiler() {
        return this.filer;
    }

    public Messager getMessager() {
        return this.messager;
    }

    public Elements getElementUtils() {
        return this.elementUtils;
    }

    public Types getTypesUtils() {
        return this.typesUtils;
    }
}

