/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.git;

import java.io.IOException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.ssssssss.magicapi.core.config.MagicAPIProperties;
import org.ssssssss.magicapi.core.config.MagicPluginConfiguration;
import org.ssssssss.magicapi.core.model.Plugin;
import org.ssssssss.magicapi.core.resource.Resource;
import org.ssssssss.magicapi.git.GitResource;
import org.ssssssss.magicapi.git.MagicGitProperties;

@Configuration
@EnableConfigurationProperties(value={MagicGitProperties.class})
public class MagicGitConfiguration
implements MagicPluginConfiguration {
    private final MagicAPIProperties properties;
    private final MagicGitProperties gitProperties;

    public MagicGitConfiguration(MagicAPIProperties properties, MagicGitProperties gitProperties) {
        this.properties = properties;
        this.gitProperties = gitProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="magic-api", name={"resource.type"}, havingValue="git")
    public Resource magicGitResource() throws IOException, GitAPIException {
        org.ssssssss.magicapi.core.config.Resource resourceConfig = this.properties.getResource();
        return GitResource.of(resourceConfig, this.gitProperties);
    }

    public Plugin plugin() {
        return new Plugin("Git");
    }
}

