package pluginloader.api

/**
 * Call method on load
 * Extremely recommend use internal, for compatibility with java 11+
 * ```
 * @Load
 * internal fun load(plugin: LoaderPlugin){}
 * //Or 'plugin: Plugin' on bukkit api
 * ```
 * @param plugin [LoaderPlugin]
 */
@Target(AnnotationTarget.FUNCTION)
@Retention(AnnotationRetention.RUNTIME)
annotation class Load

/**
 * Call method on unload, must be zero args
 * Calling before [LoaderPlugin.unloadHandler]
 * Extremely recommend use internal, for compatibility with java 11+
 * ```
 * @Unload
 * internal fun unload(){}
 * ```
 */
@Target(AnnotationTarget.FUNCTION)
@Retention(AnnotationRetention.RUNTIME)
annotation class Unload