/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Config;
import io.github.pod4dev.libpodj.model.HostConfig;
import io.github.pod4dev.libpodj.model.MountPoint;
import io.github.pod4dev.libpodj.model.NetworkingConfig;
import io.github.pod4dev.libpodj.model.Platform;
import io.github.pod4dev.libpodj.model.Port;
import io.github.pod4dev.libpodj.model.SummaryNetworkSettings;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Container
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_COMMAND = "Command";
    @SerializedName(value="Command")
    private String command;
    public static final String SERIALIZED_NAME_CONFIG = "Config";
    @SerializedName(value="Config")
    private Config config;
    public static final String SERIALIZED_NAME_CREATED = "Created";
    @SerializedName(value="Created")
    private Long created;
    public static final String SERIALIZED_NAME_DEFAULT_READ_ONLY_NON_RECURSIVE = "DefaultReadOnlyNonRecursive";
    @SerializedName(value="DefaultReadOnlyNonRecursive")
    private Boolean defaultReadOnlyNonRecursive;
    public static final String SERIALIZED_NAME_HOST_CONFIG = "HostConfig";
    @SerializedName(value="HostConfig")
    private HostConfig hostConfig;
    public static final String SERIALIZED_NAME_ID = "Id";
    @SerializedName(value="Id")
    private String id;
    public static final String SERIALIZED_NAME_IMAGE = "Image";
    @SerializedName(value="Image")
    private String image;
    public static final String SERIALIZED_NAME_IMAGE_I_D = "ImageID";
    @SerializedName(value="ImageID")
    private String imageID;
    public static final String SERIALIZED_NAME_LABELS = "Labels";
    @SerializedName(value="Labels")
    private Map<String, String> labels = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_MOUNTS = "Mounts";
    @SerializedName(value="Mounts")
    private List<@Valid MountPoint> mounts = new ArrayList<MountPoint>();
    public static final String SERIALIZED_NAME_NAME = "Name";
    @SerializedName(value="Name")
    private String name;
    public static final String SERIALIZED_NAME_NAMES = "Names";
    @SerializedName(value="Names")
    private List<String> names = new ArrayList<String>();
    public static final String SERIALIZED_NAME_NETWORK_SETTINGS = "NetworkSettings";
    @SerializedName(value="NetworkSettings")
    private SummaryNetworkSettings networkSettings;
    public static final String SERIALIZED_NAME_NETWORKING_CONFIG = "NetworkingConfig";
    @SerializedName(value="NetworkingConfig")
    private NetworkingConfig networkingConfig;
    public static final String SERIALIZED_NAME_PLATFORM = "Platform";
    @SerializedName(value="Platform")
    private Platform platform;
    public static final String SERIALIZED_NAME_PORTS = "Ports";
    @SerializedName(value="Ports")
    private List<@Valid Port> ports = new ArrayList<Port>();
    public static final String SERIALIZED_NAME_SIZE_ROOT_FS = "SizeRootFs";
    @SerializedName(value="SizeRootFs")
    private Long sizeRootFs;
    public static final String SERIALIZED_NAME_SIZE_RW = "SizeRw";
    @SerializedName(value="SizeRw")
    private Long sizeRw;
    public static final String SERIALIZED_NAME_STATE = "State";
    @SerializedName(value="State")
    private String state;
    public static final String SERIALIZED_NAME_STATUS = "Status";
    @SerializedName(value="Status")
    private String status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Container command(String command) {
        this.command = command;
        return this;
    }

    @Nullable
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public Container config(Config config) {
        this.config = config;
        return this;
    }

    @Nullable
    @Valid
    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Container created(Long created) {
        this.created = created;
        return this;
    }

    @Nullable
    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Container defaultReadOnlyNonRecursive(Boolean defaultReadOnlyNonRecursive) {
        this.defaultReadOnlyNonRecursive = defaultReadOnlyNonRecursive;
        return this;
    }

    @Nullable
    public Boolean getDefaultReadOnlyNonRecursive() {
        return this.defaultReadOnlyNonRecursive;
    }

    public void setDefaultReadOnlyNonRecursive(Boolean defaultReadOnlyNonRecursive) {
        this.defaultReadOnlyNonRecursive = defaultReadOnlyNonRecursive;
    }

    public Container hostConfig(HostConfig hostConfig) {
        this.hostConfig = hostConfig;
        return this;
    }

    @Nullable
    @Valid
    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    public void setHostConfig(HostConfig hostConfig) {
        this.hostConfig = hostConfig;
    }

    public Container id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Container image(String image) {
        this.image = image;
        return this;
    }

    @Nullable
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Container imageID(String imageID) {
        this.imageID = imageID;
        return this;
    }

    @Nullable
    public String getImageID() {
        return this.imageID;
    }

    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    public Container labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public Container putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public Container mounts(List<@Valid MountPoint> mounts) {
        this.mounts = mounts;
        return this;
    }

    public Container addMountsItem(MountPoint mountsItem) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<MountPoint>();
        }
        this.mounts.add(mountsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid MountPoint> getMounts() {
        return this.mounts;
    }

    public void setMounts(List<@Valid MountPoint> mounts) {
        this.mounts = mounts;
    }

    public Container name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Container names(List<String> names) {
        this.names = names;
        return this;
    }

    public Container addNamesItem(String namesItem) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.add(namesItem);
        return this;
    }

    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public Container networkSettings(SummaryNetworkSettings networkSettings) {
        this.networkSettings = networkSettings;
        return this;
    }

    @Nullable
    @Valid
    public SummaryNetworkSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public void setNetworkSettings(SummaryNetworkSettings networkSettings) {
        this.networkSettings = networkSettings;
    }

    public Container networkingConfig(NetworkingConfig networkingConfig) {
        this.networkingConfig = networkingConfig;
        return this;
    }

    @Nullable
    @Valid
    public NetworkingConfig getNetworkingConfig() {
        return this.networkingConfig;
    }

    public void setNetworkingConfig(NetworkingConfig networkingConfig) {
        this.networkingConfig = networkingConfig;
    }

    public Container platform(Platform platform) {
        this.platform = platform;
        return this;
    }

    @Nullable
    @Valid
    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public Container ports(List<@Valid Port> ports) {
        this.ports = ports;
        return this;
    }

    public Container addPortsItem(Port portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<Port>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid Port> getPorts() {
        return this.ports;
    }

    public void setPorts(List<@Valid Port> ports) {
        this.ports = ports;
    }

    public Container sizeRootFs(Long sizeRootFs) {
        this.sizeRootFs = sizeRootFs;
        return this;
    }

    @Nullable
    public Long getSizeRootFs() {
        return this.sizeRootFs;
    }

    public void setSizeRootFs(Long sizeRootFs) {
        this.sizeRootFs = sizeRootFs;
    }

    public Container sizeRw(Long sizeRw) {
        this.sizeRw = sizeRw;
        return this;
    }

    @Nullable
    public Long getSizeRw() {
        return this.sizeRw;
    }

    public void setSizeRw(Long sizeRw) {
        this.sizeRw = sizeRw;
    }

    public Container state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Container status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Container container = (Container)o;
        return Objects.equals(this.command, container.command) && Objects.equals(this.config, container.config) && Objects.equals(this.created, container.created) && Objects.equals(this.defaultReadOnlyNonRecursive, container.defaultReadOnlyNonRecursive) && Objects.equals(this.hostConfig, container.hostConfig) && Objects.equals(this.id, container.id) && Objects.equals(this.image, container.image) && Objects.equals(this.imageID, container.imageID) && Objects.equals(this.labels, container.labels) && Objects.equals(this.mounts, container.mounts) && Objects.equals(this.name, container.name) && Objects.equals(this.names, container.names) && Objects.equals(this.networkSettings, container.networkSettings) && Objects.equals(this.networkingConfig, container.networkingConfig) && Objects.equals(this.platform, container.platform) && Objects.equals(this.ports, container.ports) && Objects.equals(this.sizeRootFs, container.sizeRootFs) && Objects.equals(this.sizeRw, container.sizeRw) && Objects.equals(this.state, container.state) && Objects.equals(this.status, container.status);
    }

    public int hashCode() {
        return Objects.hash(this.command, this.config, this.created, this.defaultReadOnlyNonRecursive, this.hostConfig, this.id, this.image, this.imageID, this.labels, this.mounts, this.name, this.names, this.networkSettings, this.networkingConfig, this.platform, this.ports, this.sizeRootFs, this.sizeRw, this.state, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Container {\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    defaultReadOnlyNonRecursive: ").append(this.toIndentedString(this.defaultReadOnlyNonRecursive)).append("\n");
        sb.append("    hostConfig: ").append(this.toIndentedString(this.hostConfig)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imageID: ").append(this.toIndentedString(this.imageID)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    mounts: ").append(this.toIndentedString(this.mounts)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    networkSettings: ").append(this.toIndentedString(this.networkSettings)).append("\n");
        sb.append("    networkingConfig: ").append(this.toIndentedString(this.networkingConfig)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("    sizeRootFs: ").append(this.toIndentedString(this.sizeRootFs)).append("\n");
        sb.append("    sizeRw: ").append(this.toIndentedString(this.sizeRw)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayports;
        int i;
        JsonArray jsonArraymounts;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Container is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Container` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMAND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Command` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonNull()) {
            Config.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOST_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_HOST_CONFIG).isJsonNull()) {
            HostConfig.validateJsonElement(jsonObj.get(SERIALIZED_NAME_HOST_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Image` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_I_D) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ImageID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonNull() && (jsonArraymounts = jsonObj.getAsJsonArray(SERIALIZED_NAME_MOUNTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Mounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOUNTS).toString()));
            }
            for (i = 0; i < jsonArraymounts.size(); ++i) {
                MountPoint.validateJsonElement(jsonArraymounts.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMES) != null && !jsonObj.get(SERIALIZED_NAME_NAMES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Names` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_SETTINGS) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK_SETTINGS).isJsonNull()) {
            SummaryNetworkSettings.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NETWORK_SETTINGS));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORKING_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_NETWORKING_CONFIG).isJsonNull()) {
            NetworkingConfig.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NETWORKING_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_PLATFORM) != null && !jsonObj.get(SERIALIZED_NAME_PLATFORM).isJsonNull()) {
            Platform.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PLATFORM));
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTS) != null && !jsonObj.get(SERIALIZED_NAME_PORTS).isJsonNull() && (jsonArrayports = jsonObj.getAsJsonArray(SERIALIZED_NAME_PORTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PORTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Ports` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTS).toString()));
            }
            for (i = 0; i < jsonArrayports.size(); ++i) {
                Port.validateJsonElement(jsonArrayports.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `State` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
    }

    public static Container fromJson(String jsonString) throws IOException {
        return (Container)JSON.getGson().fromJson(jsonString, Container.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COMMAND);
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_CREATED);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_READ_ONLY_NON_RECURSIVE);
        openapiFields.add(SERIALIZED_NAME_HOST_CONFIG);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_IMAGE);
        openapiFields.add(SERIALIZED_NAME_IMAGE_I_D);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_MOUNTS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NAMES);
        openapiFields.add(SERIALIZED_NAME_NETWORK_SETTINGS);
        openapiFields.add(SERIALIZED_NAME_NETWORKING_CONFIG);
        openapiFields.add(SERIALIZED_NAME_PLATFORM);
        openapiFields.add(SERIALIZED_NAME_PORTS);
        openapiFields.add(SERIALIZED_NAME_SIZE_ROOT_FS);
        openapiFields.add(SERIALIZED_NAME_SIZE_RW);
        openapiFields.add(SERIALIZED_NAME_STATE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Container.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Container.class));
            return new TypeAdapter<Container>(){

                public void write(JsonWriter out, Container value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Container read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Container.validateJsonElement(jsonElement);
                    return (Container)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

