/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.LinuxInterfacePriority;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LinuxNetwork
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CLASS_I_D = "classID";
    @SerializedName(value="classID")
    private Integer classID;
    public static final String SERIALIZED_NAME_PRIORITIES = "priorities";
    @SerializedName(value="priorities")
    private List<@Valid LinuxInterfacePriority> priorities = new ArrayList<LinuxInterfacePriority>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public LinuxNetwork classID(Integer classID) {
        this.classID = classID;
        return this;
    }

    @Nullable
    public Integer getClassID() {
        return this.classID;
    }

    public void setClassID(Integer classID) {
        this.classID = classID;
    }

    public LinuxNetwork priorities(List<@Valid LinuxInterfacePriority> priorities) {
        this.priorities = priorities;
        return this;
    }

    public LinuxNetwork addPrioritiesItem(LinuxInterfacePriority prioritiesItem) {
        if (this.priorities == null) {
            this.priorities = new ArrayList<LinuxInterfacePriority>();
        }
        this.priorities.add(prioritiesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid LinuxInterfacePriority> getPriorities() {
        return this.priorities;
    }

    public void setPriorities(List<@Valid LinuxInterfacePriority> priorities) {
        this.priorities = priorities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinuxNetwork linuxNetwork = (LinuxNetwork)o;
        return Objects.equals(this.classID, linuxNetwork.classID) && Objects.equals(this.priorities, linuxNetwork.priorities);
    }

    public int hashCode() {
        return Objects.hash(this.classID, this.priorities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinuxNetwork {\n");
        sb.append("    classID: ").append(this.toIndentedString(this.classID)).append("\n");
        sb.append("    priorities: ").append(this.toIndentedString(this.priorities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraypriorities;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in LinuxNetwork is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `LinuxNetwork` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_PRIORITIES) != null && !jsonObj.get(SERIALIZED_NAME_PRIORITIES).isJsonNull() && (jsonArraypriorities = jsonObj.getAsJsonArray(SERIALIZED_NAME_PRIORITIES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PRIORITIES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `priorities` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIORITIES).toString()));
            }
            for (int i = 0; i < jsonArraypriorities.size(); ++i) {
                LinuxInterfacePriority.validateJsonElement(jsonArraypriorities.get(i));
            }
        }
    }

    public static LinuxNetwork fromJson(String jsonString) throws IOException {
        return (LinuxNetwork)JSON.getGson().fromJson(jsonString, LinuxNetwork.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CLASS_I_D);
        openapiFields.add(SERIALIZED_NAME_PRIORITIES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!LinuxNetwork.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(LinuxNetwork.class));
            return new TypeAdapter<LinuxNetwork>(){

                public void write(JsonWriter out, LinuxNetwork value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public LinuxNetwork read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    LinuxNetwork.validateJsonElement(jsonElement);
                    return (LinuxNetwork)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

