/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import javax.validation.constraints.*;
import javax.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * ExecStartLibpodRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ExecStartLibpodRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_DETACH = "Detach";
  @SerializedName(SERIALIZED_NAME_DETACH)
  private Boolean detach;

  public static final String SERIALIZED_NAME_TTY = "Tty";
  @SerializedName(SERIALIZED_NAME_TTY)
  private Boolean tty;

  public static final String SERIALIZED_NAME_H = "h";
  @SerializedName(SERIALIZED_NAME_H)
  private Integer h;

  public static final String SERIALIZED_NAME_W = "w";
  @SerializedName(SERIALIZED_NAME_W)
  private Integer w;

  public ExecStartLibpodRequest() {
  }

  public ExecStartLibpodRequest detach(Boolean detach) {
    
    this.detach = detach;
    return this;
  }

   /**
   * Detach from the command.
   * @return detach
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Detach from the command.")

  public Boolean getDetach() {
    return detach;
  }


  public void setDetach(Boolean detach) {
    this.detach = detach;
  }


  public ExecStartLibpodRequest tty(Boolean tty) {
    
    this.tty = tty;
    return this;
  }

   /**
   * Allocate a pseudo-TTY.
   * @return tty
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Allocate a pseudo-TTY.")

  public Boolean getTty() {
    return tty;
  }


  public void setTty(Boolean tty) {
    this.tty = tty;
  }


  public ExecStartLibpodRequest h(Integer h) {
    
    this.h = h;
    return this;
  }

   /**
   * Height of the TTY session in characters. Tty must be set to true to use it.
   * @return h
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Height of the TTY session in characters. Tty must be set to true to use it.")

  public Integer getH() {
    return h;
  }


  public void setH(Integer h) {
    this.h = h;
  }


  public ExecStartLibpodRequest w(Integer w) {
    
    this.w = w;
    return this;
  }

   /**
   * Width of the TTY session in characters. Tty must be set to true to use it.
   * @return w
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Width of the TTY session in characters. Tty must be set to true to use it.")

  public Integer getW() {
    return w;
  }


  public void setW(Integer w) {
    this.w = w;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExecStartLibpodRequest execStartLibpodRequest = (ExecStartLibpodRequest) o;
    return Objects.equals(this.detach, execStartLibpodRequest.detach) &&
        Objects.equals(this.tty, execStartLibpodRequest.tty) &&
        Objects.equals(this.h, execStartLibpodRequest.h) &&
        Objects.equals(this.w, execStartLibpodRequest.w);
  }

  @Override
  public int hashCode() {
    return Objects.hash(detach, tty, h, w);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExecStartLibpodRequest {\n");
    sb.append("    detach: ").append(toIndentedString(detach)).append("\n");
    sb.append("    tty: ").append(toIndentedString(tty)).append("\n");
    sb.append("    h: ").append(toIndentedString(h)).append("\n");
    sb.append("    w: ").append(toIndentedString(w)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("Detach");
    openapiFields.add("Tty");
    openapiFields.add("h");
    openapiFields.add("w");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ExecStartLibpodRequest
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ExecStartLibpodRequest.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ExecStartLibpodRequest is not found in the empty JSON string", ExecStartLibpodRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ExecStartLibpodRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ExecStartLibpodRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ExecStartLibpodRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ExecStartLibpodRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ExecStartLibpodRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ExecStartLibpodRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<ExecStartLibpodRequest>() {
           @Override
           public void write(JsonWriter out, ExecStartLibpodRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ExecStartLibpodRequest read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ExecStartLibpodRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ExecStartLibpodRequest
  * @throws IOException if the JSON string is invalid with respect to ExecStartLibpodRequest
  */
  public static ExecStartLibpodRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ExecStartLibpodRequest.class);
  }

 /**
  * Convert an instance of ExecStartLibpodRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

