/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.AccessMode;
import io.github.pod4dev.libpodj.model.CapacityRange;
import io.github.pod4dev.libpodj.model.Secret;
import io.github.pod4dev.libpodj.model.TopologyRequirement;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

public class ClusterVolumeSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ACCESS_MODE = "AccessMode";
    @SerializedName(value="AccessMode")
    private AccessMode accessMode;
    public static final String SERIALIZED_NAME_ACCESSIBILITY_REQUIREMENTS = "AccessibilityRequirements";
    @SerializedName(value="AccessibilityRequirements")
    private TopologyRequirement accessibilityRequirements;
    public static final String SERIALIZED_NAME_AVAILABILITY = "Availability";
    @SerializedName(value="Availability")
    private String availability;
    public static final String SERIALIZED_NAME_CAPACITY_RANGE = "CapacityRange";
    @SerializedName(value="CapacityRange")
    private CapacityRange capacityRange;
    public static final String SERIALIZED_NAME_GROUP = "Group";
    @SerializedName(value="Group")
    private String group;
    public static final String SERIALIZED_NAME_SECRETS = "Secrets";
    @SerializedName(value="Secrets")
    private List<Secret> secrets = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ClusterVolumeSpec accessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public ClusterVolumeSpec accessibilityRequirements(TopologyRequirement accessibilityRequirements) {
        this.accessibilityRequirements = accessibilityRequirements;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public TopologyRequirement getAccessibilityRequirements() {
        return this.accessibilityRequirements;
    }

    public void setAccessibilityRequirements(TopologyRequirement accessibilityRequirements) {
        this.accessibilityRequirements = accessibilityRequirements;
    }

    public ClusterVolumeSpec availability(String availability) {
        this.availability = availability;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAvailability() {
        return this.availability;
    }

    public void setAvailability(String availability) {
        this.availability = availability;
    }

    public ClusterVolumeSpec capacityRange(CapacityRange capacityRange) {
        this.capacityRange = capacityRange;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public CapacityRange getCapacityRange() {
        return this.capacityRange;
    }

    public void setCapacityRange(CapacityRange capacityRange) {
        this.capacityRange = capacityRange;
    }

    public ClusterVolumeSpec group(String group) {
        this.group = group;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Group defines the volume group of this volume. Volumes belonging to the same group can be referred to by group name when creating Services. Referring to a volume by group instructs swarm to treat volumes in that group interchangeably for the purpose of scheduling. Volumes with an empty string for a group technically all belong to the same, emptystring group.")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public ClusterVolumeSpec secrets(List<Secret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public ClusterVolumeSpec addSecretsItem(Secret secretsItem) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<Secret>();
        }
        this.secrets.add(secretsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Secrets defines Swarm Secrets that are passed to the CSI storage plugin when operating on this volume.")
    public List<Secret> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(List<Secret> secrets) {
        this.secrets = secrets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterVolumeSpec clusterVolumeSpec = (ClusterVolumeSpec)o;
        return Objects.equals(this.accessMode, clusterVolumeSpec.accessMode) && Objects.equals(this.accessibilityRequirements, clusterVolumeSpec.accessibilityRequirements) && Objects.equals(this.availability, clusterVolumeSpec.availability) && Objects.equals(this.capacityRange, clusterVolumeSpec.capacityRange) && Objects.equals(this.group, clusterVolumeSpec.group) && Objects.equals(this.secrets, clusterVolumeSpec.secrets);
    }

    public int hashCode() {
        return Objects.hash(this.accessMode, this.accessibilityRequirements, this.availability, this.capacityRange, this.group, this.secrets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClusterVolumeSpec {\n");
        sb.append("    accessMode: ").append(this.toIndentedString(this.accessMode)).append("\n");
        sb.append("    accessibilityRequirements: ").append(this.toIndentedString(this.accessibilityRequirements)).append("\n");
        sb.append("    availability: ").append(this.toIndentedString(this.availability)).append("\n");
        sb.append("    capacityRange: ").append(this.toIndentedString(this.capacityRange)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    secrets: ").append(this.toIndentedString(this.secrets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysecrets;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ClusterVolumeSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ClusterVolumeSpec` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_MODE) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_MODE).isJsonNull()) {
            AccessMode.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS_MODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESSIBILITY_REQUIREMENTS) != null && !jsonObj.get(SERIALIZED_NAME_ACCESSIBILITY_REQUIREMENTS).isJsonNull()) {
            TopologyRequirement.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESSIBILITY_REQUIREMENTS));
        }
        if (jsonObj.get(SERIALIZED_NAME_AVAILABILITY) != null && !jsonObj.get(SERIALIZED_NAME_AVAILABILITY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AVAILABILITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Availability` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AVAILABILITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAPACITY_RANGE) != null && !jsonObj.get(SERIALIZED_NAME_CAPACITY_RANGE).isJsonNull()) {
            CapacityRange.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CAPACITY_RANGE));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUP) != null && !jsonObj.get(SERIALIZED_NAME_GROUP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Group` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRETS) != null && !jsonObj.get(SERIALIZED_NAME_SECRETS).isJsonNull() && (jsonArraysecrets = jsonObj.getAsJsonArray(SERIALIZED_NAME_SECRETS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SECRETS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Secrets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRETS).toString()));
            }
            for (int i = 0; i < jsonArraysecrets.size(); ++i) {
                Secret.validateJsonObject(jsonArraysecrets.get(i).getAsJsonObject());
            }
        }
    }

    public static ClusterVolumeSpec fromJson(String jsonString) throws IOException {
        return (ClusterVolumeSpec)JSON.getGson().fromJson(jsonString, ClusterVolumeSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCESS_MODE);
        openapiFields.add(SERIALIZED_NAME_ACCESSIBILITY_REQUIREMENTS);
        openapiFields.add(SERIALIZED_NAME_AVAILABILITY);
        openapiFields.add(SERIALIZED_NAME_CAPACITY_RANGE);
        openapiFields.add(SERIALIZED_NAME_GROUP);
        openapiFields.add(SERIALIZED_NAME_SECRETS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ClusterVolumeSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ClusterVolumeSpec.class));
            return new TypeAdapter<ClusterVolumeSpec>(){

                public void write(JsonWriter out, ClusterVolumeSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ClusterVolumeSpec read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ClusterVolumeSpec.validateJsonObject(jsonObj);
                    return (ClusterVolumeSpec)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

