/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.PluginDevice;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="PluginConfigLinux plugin config linux")
public class PluginConfigLinux
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ALLOW_ALL_DEVICES = "AllowAllDevices";
    @SerializedName(value="AllowAllDevices")
    private Boolean allowAllDevices;
    public static final String SERIALIZED_NAME_CAPABILITIES = "Capabilities";
    @SerializedName(value="Capabilities")
    private List<String> capabilities = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DEVICES = "Devices";
    @SerializedName(value="Devices")
    private List<PluginDevice> devices = new ArrayList<PluginDevice>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PluginConfigLinux allowAllDevices(Boolean allowAllDevices) {
        this.allowAllDevices = allowAllDevices;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="allow all devices")
    public Boolean getAllowAllDevices() {
        return this.allowAllDevices;
    }

    public void setAllowAllDevices(Boolean allowAllDevices) {
        this.allowAllDevices = allowAllDevices;
    }

    public PluginConfigLinux capabilities(List<String> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public PluginConfigLinux addCapabilitiesItem(String capabilitiesItem) {
        this.capabilities.add(capabilitiesItem);
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="capabilities")
    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(List<String> capabilities) {
        this.capabilities = capabilities;
    }

    public PluginConfigLinux devices(List<PluginDevice> devices) {
        this.devices = devices;
        return this;
    }

    public PluginConfigLinux addDevicesItem(PluginDevice devicesItem) {
        this.devices.add(devicesItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="devices")
    public List<PluginDevice> getDevices() {
        return this.devices;
    }

    public void setDevices(List<PluginDevice> devices) {
        this.devices = devices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginConfigLinux pluginConfigLinux = (PluginConfigLinux)o;
        return Objects.equals(this.allowAllDevices, pluginConfigLinux.allowAllDevices) && Objects.equals(this.capabilities, pluginConfigLinux.capabilities) && Objects.equals(this.devices, pluginConfigLinux.devices);
    }

    public int hashCode() {
        return Objects.hash(this.allowAllDevices, this.capabilities, this.devices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PluginConfigLinux {\n");
        sb.append("    allowAllDevices: ").append(this.toIndentedString(this.allowAllDevices)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraydevices;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PluginConfigLinux is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PluginConfigLinux` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAPABILITIES) != null && !jsonObj.get(SERIALIZED_NAME_CAPABILITIES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CAPABILITIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Capabilities` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAPABILITIES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonNull() && (jsonArraydevices = jsonObj.getAsJsonArray(SERIALIZED_NAME_DEVICES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Devices` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICES).toString()));
            }
            for (int i = 0; i < jsonArraydevices.size(); ++i) {
                PluginDevice.validateJsonObject(jsonArraydevices.get(i).getAsJsonObject());
            }
        }
    }

    public static PluginConfigLinux fromJson(String jsonString) throws IOException {
        return (PluginConfigLinux)JSON.getGson().fromJson(jsonString, PluginConfigLinux.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOW_ALL_DEVICES);
        openapiFields.add(SERIALIZED_NAME_CAPABILITIES);
        openapiFields.add(SERIALIZED_NAME_DEVICES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ALLOW_ALL_DEVICES);
        openapiRequiredFields.add(SERIALIZED_NAME_CAPABILITIES);
        openapiRequiredFields.add(SERIALIZED_NAME_DEVICES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PluginConfigLinux.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PluginConfigLinux.class));
            return new TypeAdapter<PluginConfigLinux>(){

                public void write(JsonWriter out, PluginConfigLinux value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PluginConfigLinux read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PluginConfigLinux.validateJsonObject(jsonObj);
                    return (PluginConfigLinux)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

