/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.ManifestSummary;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class Summary
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONTAINERS = "Containers";
    @SerializedName(value="Containers")
    private Long containers;
    public static final String SERIALIZED_NAME_CREATED = "Created";
    @SerializedName(value="Created")
    private Long created;
    public static final String SERIALIZED_NAME_ID = "Id";
    @SerializedName(value="Id")
    private String id;
    public static final String SERIALIZED_NAME_LABELS = "Labels";
    @SerializedName(value="Labels")
    private Map<String, String> labels = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_PARENT_ID = "ParentId";
    @SerializedName(value="ParentId")
    private String parentId;
    public static final String SERIALIZED_NAME_REPO_DIGESTS = "RepoDigests";
    @SerializedName(value="RepoDigests")
    private List<String> repoDigests = new ArrayList<String>();
    public static final String SERIALIZED_NAME_REPO_TAGS = "RepoTags";
    @SerializedName(value="RepoTags")
    private List<String> repoTags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SHARED_SIZE = "SharedSize";
    @SerializedName(value="SharedSize")
    private Long sharedSize;
    public static final String SERIALIZED_NAME_SIZE = "Size";
    @SerializedName(value="Size")
    private Long size;
    public static final String SERIALIZED_NAME_MANIFESTS = "Manifests";
    @SerializedName(value="Manifests")
    private List<ManifestSummary> manifests = null;
    public static final String SERIALIZED_NAME_VIRTUAL_SIZE = "VirtualSize";
    @SerializedName(value="VirtualSize")
    private Long virtualSize;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Summary containers(Long containers) {
        this.containers = containers;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Number of containers using this image. Includes both stopped and running containers.  This size is not calculated by default, and depends on which API endpoint is used. `-1` indicates that the value has not been set / calculated.")
    public Long getContainers() {
        return this.containers;
    }

    public void setContainers(Long containers) {
        this.containers = containers;
    }

    public Summary created(Long created) {
        this.created = created;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Date and time at which the image was created as a Unix timestamp (number of seconds since EPOCH).")
    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Summary id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="ID is the content-addressable ID of an image.  This identifier is a content-addressable digest calculated from the image's configuration (which includes the digests of layers used by the image).  Note that this digest differs from the `RepoDigests` below, which holds digests of image manifests that reference the image.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Summary labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public Summary putLabelsItem(String key, String labelsItem) {
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="User-defined key/value metadata.")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public Summary parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="ID of the parent image.  Depending on how the image was created, this field may be empty and is only set for images that were built/created locally. This field is empty if the image was pulled from an image registry.")
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Summary repoDigests(List<String> repoDigests) {
        this.repoDigests = repoDigests;
        return this;
    }

    public Summary addRepoDigestsItem(String repoDigestsItem) {
        this.repoDigests.add(repoDigestsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="List of content-addressable digests of locally available image manifests that the image is referenced from. Multiple manifests can refer to the same image.  These digests are usually only available if the image was either pulled from a registry, or if the image was pushed to a registry, which is when the manifest is generated and its digest calculated.")
    public List<String> getRepoDigests() {
        return this.repoDigests;
    }

    public void setRepoDigests(List<String> repoDigests) {
        this.repoDigests = repoDigests;
    }

    public Summary repoTags(List<String> repoTags) {
        this.repoTags = repoTags;
        return this;
    }

    public Summary addRepoTagsItem(String repoTagsItem) {
        this.repoTags.add(repoTagsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="List of image names/tags in the local image cache that reference this image.  Multiple image tags can refer to the same image, and this list may be empty if no tags reference the image, in which case the image is \"untagged\", in which case it can still be referenced by its ID.")
    public List<String> getRepoTags() {
        return this.repoTags;
    }

    public void setRepoTags(List<String> repoTags) {
        this.repoTags = repoTags;
    }

    public Summary sharedSize(Long sharedSize) {
        this.sharedSize = sharedSize;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Total size of image layers that are shared between this image and other images.  This size is not calculated by default. `-1` indicates that the value has not been set / calculated.")
    public Long getSharedSize() {
        return this.sharedSize;
    }

    public void setSharedSize(Long sharedSize) {
        this.sharedSize = sharedSize;
    }

    public Summary size(Long size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Total size of the image including all layers it is composed of.")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Summary manifests(List<ManifestSummary> manifests) {
        this.manifests = manifests;
        return this;
    }

    public Summary addManifestsItem(ManifestSummary manifestsItem) {
        if (this.manifests == null) {
            this.manifests = new ArrayList<ManifestSummary>();
        }
        this.manifests.add(manifestsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Manifests is a list of image manifests available in this image.  It provides a more detailed view of the platform-specific image manifests or other image-attached data like build attestations.  WARNING: This is experimental and may change at any time without any backward compatibility.")
    public List<ManifestSummary> getManifests() {
        return this.manifests;
    }

    public void setManifests(List<ManifestSummary> manifests) {
        this.manifests = manifests;
    }

    public Summary virtualSize(Long virtualSize) {
        this.virtualSize = virtualSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total size of the image including all layers it is composed of.  Deprecated: this field is omitted in API v1.44, but kept for backward compatibility. Use Size instead.")
    public Long getVirtualSize() {
        return this.virtualSize;
    }

    public void setVirtualSize(Long virtualSize) {
        this.virtualSize = virtualSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Summary summary = (Summary)o;
        return Objects.equals(this.containers, summary.containers) && Objects.equals(this.created, summary.created) && Objects.equals(this.id, summary.id) && Objects.equals(this.labels, summary.labels) && Objects.equals(this.parentId, summary.parentId) && Objects.equals(this.repoDigests, summary.repoDigests) && Objects.equals(this.repoTags, summary.repoTags) && Objects.equals(this.sharedSize, summary.sharedSize) && Objects.equals(this.size, summary.size) && Objects.equals(this.manifests, summary.manifests) && Objects.equals(this.virtualSize, summary.virtualSize);
    }

    public int hashCode() {
        return Objects.hash(this.containers, this.created, this.id, this.labels, this.parentId, this.repoDigests, this.repoTags, this.sharedSize, this.size, this.manifests, this.virtualSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Summary {\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    repoDigests: ").append(this.toIndentedString(this.repoDigests)).append("\n");
        sb.append("    repoTags: ").append(this.toIndentedString(this.repoTags)).append("\n");
        sb.append("    sharedSize: ").append(this.toIndentedString(this.sharedSize)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    manifests: ").append(this.toIndentedString(this.manifests)).append("\n");
        sb.append("    virtualSize: ").append(this.toIndentedString(this.virtualSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraymanifests;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Summary is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Summary` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PARENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_PARENT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PARENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ParentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPO_DIGESTS) != null && !jsonObj.get(SERIALIZED_NAME_REPO_DIGESTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REPO_DIGESTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `RepoDigests` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPO_DIGESTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPO_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_REPO_TAGS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REPO_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `RepoTags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPO_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MANIFESTS) != null && !jsonObj.get(SERIALIZED_NAME_MANIFESTS).isJsonNull() && (jsonArraymanifests = jsonObj.getAsJsonArray(SERIALIZED_NAME_MANIFESTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MANIFESTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Manifests` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MANIFESTS).toString()));
            }
            for (int i = 0; i < jsonArraymanifests.size(); ++i) {
                ManifestSummary.validateJsonObject(jsonArraymanifests.get(i).getAsJsonObject());
            }
        }
    }

    public static Summary fromJson(String jsonString) throws IOException {
        return (Summary)JSON.getGson().fromJson(jsonString, Summary.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_CREATED);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_PARENT_ID);
        openapiFields.add(SERIALIZED_NAME_REPO_DIGESTS);
        openapiFields.add(SERIALIZED_NAME_REPO_TAGS);
        openapiFields.add(SERIALIZED_NAME_SHARED_SIZE);
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiFields.add(SERIALIZED_NAME_MANIFESTS);
        openapiFields.add(SERIALIZED_NAME_VIRTUAL_SIZE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CONTAINERS);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_LABELS);
        openapiRequiredFields.add(SERIALIZED_NAME_PARENT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_REPO_DIGESTS);
        openapiRequiredFields.add(SERIALIZED_NAME_REPO_TAGS);
        openapiRequiredFields.add(SERIALIZED_NAME_SHARED_SIZE);
        openapiRequiredFields.add(SERIALIZED_NAME_SIZE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Summary.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Summary.class));
            return new TypeAdapter<Summary>(){

                public void write(JsonWriter out, Summary value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Summary read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Summary.validateJsonObject(jsonObj);
                    return (Summary)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

