/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonElement;
import io.gsonfire.GsonFireBuilder;
import io.gsonfire.TypeSelector;

import okio.ByteString;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.HashMap;

/*
 * A JSON utility class
 *
 * NOTE: in the future, this class may be converted to static, which may break
 *       backward-compatibility
 */
public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson = false;
    private static DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
    private static SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
    private static LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();
    private static ByteArrayAdapter byteArrayAdapter = new ByteArrayAdapter();

    @SuppressWarnings("unchecked")
    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder()
        ;
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    /**
     * Returns the Java class that implements the OpenAPI schema for the specified discriminator value.
     *
     * @param classByDiscriminatorValue The map of discriminator values to Java classes.
     * @param discriminatorValue The value of the OpenAPI discriminator in the input data.
     * @return The Java class that implements the OpenAPI schema
     */
    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class) classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    static {
        GsonBuilder gsonBuilder = createGson();
        gsonBuilder.registerTypeAdapter(Date.class, dateTypeAdapter);
        gsonBuilder.registerTypeAdapter(java.sql.Date.class, sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(OffsetDateTime.class, offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter(LocalDate.class, localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(byte[].class, byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.AccessMode.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Address.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.AttestationProperties.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.AuthConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.AuthReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.AuthenticateOKBody.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.AutoUserNsOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.BindOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.CPUUsage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.CapacityRange.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ClusterVolume.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ClusterVolumeSpec.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ComponentVersion.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Config.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ConfigReference.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ConmonInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ConnectOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Container.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerBasicConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerCgroupConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerCreateResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerExecRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerHealthCheckConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerJSON.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerNetworkConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerNetworkStats.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerNode.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerResourceConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerSecurityConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerSize.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerState.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerStats.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerStorageConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerStore.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerTopOKBody.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerUpdateLibpod201Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerUpdateOKBody.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerUpdateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerWait200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainerWait200ResponseError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainersPruneReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ContainersPruneReportLibpod.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.CreateContainerConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.CreateOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.CreateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.CreateResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.DNSNetworkInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.DeleteResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Descriptor.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.DeviceMapping.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.DeviceRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.DisconnectOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.DistributionInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Driver.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.DriverData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.EndpointIPAMConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.EndpointResource.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.EndpointSettings.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ErrorModel.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ErrorResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ExecStartLibpodRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ExecStartRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.FilesystemChange.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.GraphDriverData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Health.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.HealthCheckLog.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.HealthCheckResults.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.HealthcheckConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.HealthcheckResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.History.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.HistoryResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.HistoryResponseItem.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.HostConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.HostInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.IDMap.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.IDMappingOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.IDMappings.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.IPAM.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.IPAMConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.IPNet.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.IdResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageBuild200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageBuildLibpod200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageDelete200ResponseInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageImportReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageInspect.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageLoadReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageProperties.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImagePropertiesSize.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageSearch200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageStore.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageTreeReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ImageVolume.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Info.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Inspect.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectAdditionalNetwork.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectBlkioThrottleDevice.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectBlkioWeightDevice.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectContainerConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectContainerData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectContainerHostConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectContainerState.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectDevice.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectExecProcess.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectExecSession.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectHostPort.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectIDMappings.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectLogConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectMount.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectNetworkSettings.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectPodContainerInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectPodData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectPodInfraConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectRestartPolicy.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectSecret.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.InspectUlimit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LeaseRange.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LibpodContainersRmReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LibpodImageSummary.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LibpodImagesPullReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LibpodImagesRemoveReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LibpodInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxBlockIO.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxBlockIODevice.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxCPU.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxDevice.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxDeviceCgroup.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxHugepageLimit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxIDMapping.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxIntelRdt.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxInterfacePriority.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxMemory.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxNetwork.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxPersonality.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxPids.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxRdma.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxResources.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxThrottleDevice.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LinuxWeightDevice.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ListContainer.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ListContainerNamespaces.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ListPodContainer.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ListPodsReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LogConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.LogConfigLibpod.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ManifestAddArtifactOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ManifestAddOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ManifestAnnotateOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ManifestModifyOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ManifestModifyReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ManifestPushReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ManifestRemoveReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ManifestSummary.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ManifestSummarySize.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Meta.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Metadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Mount.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.MountPoint.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NamedVolume.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Namespace.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetAddress.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetInterface.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Network.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetworkConnectOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetworkContainerInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetworkCreate201Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetworkCreateLibpod.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetworkInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetworkInspectReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetworkPrune200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetworkPruneReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetworkRmReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetworkSettings.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetworkUpdateOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.NetworkingConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.OCIRuntimeInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.OverlayVolume.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.POSIXRlimit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PastaInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PeerInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PerNetworkOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Platform.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PlayKubePod.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PlayKubeReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PlayKubeVolume.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PlaySecret.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Plugin.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PluginConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PluginConfigArgs.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PluginConfigInterface.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PluginConfigLinux.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PluginConfigNetwork.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PluginConfigRootfs.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PluginConfigUser.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PluginDevice.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PluginEnv.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PluginInterfaceType.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PluginMount.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PluginSettings.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Plugins.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodBasicConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodCgroupConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodCreateOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodKillReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodNetworkConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodPauseReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodPruneReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodResourceConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodRestartReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodRmReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodSecurityConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodSpecGenerator.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodStartReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodStatsReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodStopReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodStorageConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodTopOKBody.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PodUnpauseReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Port.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PortBinding.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PortMapping.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PruneReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.PublishStatus.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.RemoteSocket.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Resources.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.RestartPolicy.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.RootFS.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Route.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Schema2HealthConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Schema2ListPublic.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Schema2ManifestDescriptor.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Schema2PlatformSpec.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ScpReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Secret.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SecretCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SecretCreateReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SecretDeleteLibpod404Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SecretDriverSpec.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SecretInfoReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SecretInfoReportCompat.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SecretRmReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SecretSpec.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SecretVersion.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SecurityInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ServiceCreateResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ServiceInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ServiceUpdateResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SlirpInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SpecGenerator.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.StartupHealthCheck.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.StoreInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Subnet.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Summary.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SummaryNetworkSettings.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SystemCheckReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SystemComponentVersion.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SystemComponentVersionPlatform.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SystemDfContainerReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SystemDfImageReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SystemDfReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SystemDfVolumeReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.SystemPruneReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Task.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.ThrottleDevice.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.TmpfsOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Topology.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.TopologyRequirement.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.TypeMount.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Ulimit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.UpdateConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.UpdateContainerDevicesLimits.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.UpdateEntities.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.UpdateHealthCheckConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.UsageData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Version.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.Volume.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.VolumeConfigResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.VolumeCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.VolumeCreateOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.VolumeOptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.VolumeRmReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.WaitExitError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.WaitResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new io.github.pod4dev.libpodj.model.WeightDevice.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    /**
     * Get Gson.
     *
     * @return Gson
     */
    public static Gson getGson() {
        return gson;
    }

    /**
     * Set Gson.
     *
     * @param gson Gson
     */
    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    /**
     * Serialize the given Java object into JSON string.
     *
     * @param obj Object
     * @return String representation of the JSON
     */
    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    /**
     * Deserialize the given JSON string to Java object.
     *
     * @param <T>        Type
     * @param body       The JSON string
     * @param returnType The type to deserialize into
     * @return The deserialized Java object
     */
    @SuppressWarnings("unchecked")
    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(new StringReader(body));
                // see https://google-gson.googlecode.com/svn/trunk/gson/docs/javadocs/com/google/gson/stream/JsonReader.html#setLenient(boolean)
                jsonReader.setLenient(true);
                return gson.fromJson(jsonReader, returnType);
            } else {
                return gson.fromJson(body, returnType);
            }
        } catch (JsonParseException e) {
            // Fallback processing when failed to parse JSON form response body:
            // return the response body string directly for the String return type;
            if (returnType.equals(String.class)) {
                return (T) body;
            } else {
                throw (e);
            }
        }
    }

    /**
     * Gson TypeAdapter for Byte Array type
     */
    public static class ByteArrayAdapter extends TypeAdapter<byte[]> {

        @Override
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of(value).base64());
            }
        }

        @Override
        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String bytesAsBase64 = in.nextString();
                    ByteString byteString = ByteString.decodeBase64(bytesAsBase64);
                    return byteString.toByteArray();
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 OffsetDateTime type
     */
    public static class OffsetDateTimeTypeAdapter extends TypeAdapter<OffsetDateTime> {

        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    if (date.endsWith("+0000")) {
                        date = date.substring(0, date.length()-5) + "Z";
                    }
                    return OffsetDateTime.parse(date, formatter);
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 LocalDate type
     */
    public static class LocalDateTypeAdapter extends TypeAdapter<LocalDate> {

        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    return LocalDate.parse(date, formatter);
            }
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    /**
     * Gson TypeAdapter for java.sql.Date type
     * If the dateFormat is null, a simple "yyyy-MM-dd" format will be used
     * (more efficient than SimpleDateFormat).
     */
    public static class SqlDateTypeAdapter extends TypeAdapter<java.sql.Date> {

        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {}

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = date.toString();
                }
                out.value(value);
            }
        }

        @Override
        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    try {
                        if (dateFormat != null) {
                            return new java.sql.Date(dateFormat.parse(date).getTime());
                        }
                        return new java.sql.Date(ISO8601Utils.parse(date, new ParsePosition(0)).getTime());
                    } catch (ParseException e) {
                        throw new JsonParseException(e);
                    }
            }
        }
    }

    /**
     * Gson TypeAdapter for java.util.Date type
     * If the dateFormat is null, ISO8601Utils will be used.
     */
    public static class DateTypeAdapter extends TypeAdapter<Date> {

        private DateFormat dateFormat;

        public DateTypeAdapter() {}

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = ISO8601Utils.format(date, true);
                }
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL:
                        in.nextNull();
                        return null;
                    default:
                        String date = in.nextString();
                        try {
                            if (dateFormat != null) {
                                return dateFormat.parse(date);
                            }
                            return ISO8601Utils.parse(date, new ParsePosition(0));
                        } catch (ParseException e) {
                            throw new JsonParseException(e);
                        }
                }
            } catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }
}
