/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.IDResponse;
import io.github.pod4dev.libpodj.model.LibpodImagesRemoveReport;
import io.github.pod4dev.libpodj.model.ManifestAddOptions;
import io.github.pod4dev.libpodj.model.ManifestModifyOptions;
import io.github.pod4dev.libpodj.model.ManifestModifyReport;
import io.github.pod4dev.libpodj.model.Schema2ListPublic;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ManifestsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ManifestsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ManifestsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call manifestAddLibpodCall(String name, ManifestAddOptions options, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ManifestAddOptions localVarPostBody = options;
        String localVarPath = "/libpod/manifests/{name}/add".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call manifestAddLibpodValidateBeforeCall(String name, ManifestAddOptions options, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling manifestAddLibpod(Async)");
        }
        return this.manifestAddLibpodCall(name, options, _callback);
    }

    private ApiResponse<IDResponse> manifestAddLibpodWithHttpInfo(@NotNull String name, ManifestAddOptions options) throws ApiException {
        Call localVarCall = this.manifestAddLibpodValidateBeforeCall(name, options, null);
        Type localVarReturnType = new TypeToken<IDResponse>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call manifestAddLibpodAsync(String name, ManifestAddOptions options, ApiCallback<IDResponse> _callback) throws ApiException {
        Call localVarCall = this.manifestAddLibpodValidateBeforeCall(name, options, _callback);
        Type localVarReturnType = new TypeToken<IDResponse>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APImanifestAddLibpodRequest manifestAddLibpod(String name) {
        return new APImanifestAddLibpodRequest(name);
    }

    private Call manifestCreateLibpodCall(String name, String images, Boolean all, Boolean amend, ManifestModifyOptions options, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ManifestModifyOptions localVarPostBody = options;
        String localVarPath = "/libpod/manifests/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (images != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("images", images));
        }
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if (amend != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amend", amend));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call manifestCreateLibpodValidateBeforeCall(String name, String images, Boolean all, Boolean amend, ManifestModifyOptions options, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling manifestCreateLibpod(Async)");
        }
        if (images == null) {
            throw new ApiException("Missing the required parameter 'images' when calling manifestCreateLibpod(Async)");
        }
        return this.manifestCreateLibpodCall(name, images, all, amend, options, _callback);
    }

    private ApiResponse<IDResponse> manifestCreateLibpodWithHttpInfo(@NotNull String name, @NotNull String images, Boolean all, Boolean amend, ManifestModifyOptions options) throws ApiException {
        Call localVarCall = this.manifestCreateLibpodValidateBeforeCall(name, images, all, amend, options, null);
        Type localVarReturnType = new TypeToken<IDResponse>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call manifestCreateLibpodAsync(String name, String images, Boolean all, Boolean amend, ManifestModifyOptions options, ApiCallback<IDResponse> _callback) throws ApiException {
        Call localVarCall = this.manifestCreateLibpodValidateBeforeCall(name, images, all, amend, options, _callback);
        Type localVarReturnType = new TypeToken<IDResponse>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APImanifestCreateLibpodRequest manifestCreateLibpod(String name, String images) {
        return new APImanifestCreateLibpodRequest(name, images);
    }

    private Call manifestDeleteLibpodCall(String name, Boolean ignore, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/manifests/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ignore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignore", ignore));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call manifestDeleteLibpodValidateBeforeCall(String name, Boolean ignore, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling manifestDeleteLibpod(Async)");
        }
        return this.manifestDeleteLibpodCall(name, ignore, _callback);
    }

    private ApiResponse<LibpodImagesRemoveReport> manifestDeleteLibpodWithHttpInfo(@NotNull String name, Boolean ignore) throws ApiException {
        Call localVarCall = this.manifestDeleteLibpodValidateBeforeCall(name, ignore, null);
        Type localVarReturnType = new TypeToken<LibpodImagesRemoveReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call manifestDeleteLibpodAsync(String name, Boolean ignore, ApiCallback<LibpodImagesRemoveReport> _callback) throws ApiException {
        Call localVarCall = this.manifestDeleteLibpodValidateBeforeCall(name, ignore, _callback);
        Type localVarReturnType = new TypeToken<LibpodImagesRemoveReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APImanifestDeleteLibpodRequest manifestDeleteLibpod(String name) {
        return new APImanifestDeleteLibpodRequest(name);
    }

    private Call manifestExistsLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/manifests/{name}/exists".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call manifestExistsLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling manifestExistsLibpod(Async)");
        }
        return this.manifestExistsLibpodCall(name, _callback);
    }

    private ApiResponse<Void> manifestExistsLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.manifestExistsLibpodValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call manifestExistsLibpodAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.manifestExistsLibpodValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APImanifestExistsLibpodRequest manifestExistsLibpod(String name) {
        return new APImanifestExistsLibpodRequest(name);
    }

    private Call manifestInspectLibpodCall(String name, Boolean tlsVerify, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/manifests/{name}/json".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (tlsVerify != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call manifestInspectLibpodValidateBeforeCall(String name, Boolean tlsVerify, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling manifestInspectLibpod(Async)");
        }
        return this.manifestInspectLibpodCall(name, tlsVerify, _callback);
    }

    private ApiResponse<Schema2ListPublic> manifestInspectLibpodWithHttpInfo(@NotNull String name, Boolean tlsVerify) throws ApiException {
        Call localVarCall = this.manifestInspectLibpodValidateBeforeCall(name, tlsVerify, null);
        Type localVarReturnType = new TypeToken<Schema2ListPublic>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call manifestInspectLibpodAsync(String name, Boolean tlsVerify, ApiCallback<Schema2ListPublic> _callback) throws ApiException {
        Call localVarCall = this.manifestInspectLibpodValidateBeforeCall(name, tlsVerify, _callback);
        Type localVarReturnType = new TypeToken<Schema2ListPublic>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APImanifestInspectLibpodRequest manifestInspectLibpod(String name) {
        return new APImanifestInspectLibpodRequest(name);
    }

    private Call manifestModifyLibpodCall(String name, ManifestModifyOptions options, Boolean tlsVerify, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ManifestModifyOptions localVarPostBody = options;
        String localVarPath = "/libpod/manifests/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (tlsVerify != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call manifestModifyLibpodValidateBeforeCall(String name, ManifestModifyOptions options, Boolean tlsVerify, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling manifestModifyLibpod(Async)");
        }
        if (options == null) {
            throw new ApiException("Missing the required parameter 'options' when calling manifestModifyLibpod(Async)");
        }
        return this.manifestModifyLibpodCall(name, options, tlsVerify, _callback);
    }

    private ApiResponse<ManifestModifyReport> manifestModifyLibpodWithHttpInfo(@NotNull String name, @NotNull ManifestModifyOptions options, Boolean tlsVerify) throws ApiException {
        Call localVarCall = this.manifestModifyLibpodValidateBeforeCall(name, options, tlsVerify, null);
        Type localVarReturnType = new TypeToken<ManifestModifyReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call manifestModifyLibpodAsync(String name, ManifestModifyOptions options, Boolean tlsVerify, ApiCallback<ManifestModifyReport> _callback) throws ApiException {
        Call localVarCall = this.manifestModifyLibpodValidateBeforeCall(name, options, tlsVerify, _callback);
        Type localVarReturnType = new TypeToken<ManifestModifyReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APImanifestModifyLibpodRequest manifestModifyLibpod(String name, ManifestModifyOptions options) {
        return new APImanifestModifyLibpodRequest(name, options);
    }

    private Call manifestPushLibpodCall(String name, String destination, List<String> addCompression, Boolean forceCompressionFormat, Boolean all, Boolean tlsVerify, Boolean quiet, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/manifests/{name}/registry/{destination}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{destination}", this.localVarApiClient.escapeString(destination.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (addCompression != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "addCompression", addCompression));
        }
        if (forceCompressionFormat != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("forceCompressionFormat", forceCompressionFormat));
        }
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if (tlsVerify != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }
        if (quiet != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("quiet", quiet));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call manifestPushLibpodValidateBeforeCall(String name, String destination, List<String> addCompression, Boolean forceCompressionFormat, Boolean all, Boolean tlsVerify, Boolean quiet, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling manifestPushLibpod(Async)");
        }
        if (destination == null) {
            throw new ApiException("Missing the required parameter 'destination' when calling manifestPushLibpod(Async)");
        }
        return this.manifestPushLibpodCall(name, destination, addCompression, forceCompressionFormat, all, tlsVerify, quiet, _callback);
    }

    private ApiResponse<IDResponse> manifestPushLibpodWithHttpInfo(@NotNull String name, @NotNull String destination, List<String> addCompression, Boolean forceCompressionFormat, Boolean all, Boolean tlsVerify, Boolean quiet) throws ApiException {
        Call localVarCall = this.manifestPushLibpodValidateBeforeCall(name, destination, addCompression, forceCompressionFormat, all, tlsVerify, quiet, null);
        Type localVarReturnType = new TypeToken<IDResponse>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call manifestPushLibpodAsync(String name, String destination, List<String> addCompression, Boolean forceCompressionFormat, Boolean all, Boolean tlsVerify, Boolean quiet, ApiCallback<IDResponse> _callback) throws ApiException {
        Call localVarCall = this.manifestPushLibpodValidateBeforeCall(name, destination, addCompression, forceCompressionFormat, all, tlsVerify, quiet, _callback);
        Type localVarReturnType = new TypeToken<IDResponse>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APImanifestPushLibpodRequest manifestPushLibpod(String name, String destination) {
        return new APImanifestPushLibpodRequest(name, destination);
    }

    private Call manifestPushV3LibpodCall(String name, String destination, Boolean all, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/manifests/{name}/push".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (destination != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("destination", destination));
        }
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call manifestPushV3LibpodValidateBeforeCall(String name, String destination, Boolean all, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling manifestPushV3Libpod(Async)");
        }
        if (destination == null) {
            throw new ApiException("Missing the required parameter 'destination' when calling manifestPushV3Libpod(Async)");
        }
        return this.manifestPushV3LibpodCall(name, destination, all, _callback);
    }

    private ApiResponse<IDResponse> manifestPushV3LibpodWithHttpInfo(@NotNull String name, @NotNull String destination, Boolean all) throws ApiException {
        Call localVarCall = this.manifestPushV3LibpodValidateBeforeCall(name, destination, all, null);
        Type localVarReturnType = new TypeToken<IDResponse>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call manifestPushV3LibpodAsync(String name, String destination, Boolean all, ApiCallback<IDResponse> _callback) throws ApiException {
        Call localVarCall = this.manifestPushV3LibpodValidateBeforeCall(name, destination, all, _callback);
        Type localVarReturnType = new TypeToken<IDResponse>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APImanifestPushV3LibpodRequest manifestPushV3Libpod(String name, String destination) {
        return new APImanifestPushV3LibpodRequest(name, destination);
    }

    public class APImanifestAddLibpodRequest {
        private final String name;
        private ManifestAddOptions options;

        private APImanifestAddLibpodRequest(String name) {
            this.name = name;
        }

        public APImanifestAddLibpodRequest options(ManifestAddOptions options) {
            this.options = options;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ManifestsApi.this.manifestAddLibpodCall(this.name, this.options, _callback);
        }

        public IDResponse execute() throws ApiException {
            ApiResponse<IDResponse> localVarResp = ManifestsApi.this.manifestAddLibpodWithHttpInfo(this.name, this.options);
            return localVarResp.getData();
        }

        public ApiResponse<IDResponse> executeWithHttpInfo() throws ApiException {
            return ManifestsApi.this.manifestAddLibpodWithHttpInfo(this.name, this.options);
        }

        public Call executeAsync(ApiCallback<IDResponse> _callback) throws ApiException {
            return ManifestsApi.this.manifestAddLibpodAsync(this.name, this.options, _callback);
        }
    }

    public class APImanifestCreateLibpodRequest {
        private final String name;
        private final String images;
        private Boolean all;
        private Boolean amend;
        private ManifestModifyOptions options;

        private APImanifestCreateLibpodRequest(String name, String images) {
            this.name = name;
            this.images = images;
        }

        public APImanifestCreateLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public APImanifestCreateLibpodRequest amend(Boolean amend) {
            this.amend = amend;
            return this;
        }

        public APImanifestCreateLibpodRequest options(ManifestModifyOptions options) {
            this.options = options;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ManifestsApi.this.manifestCreateLibpodCall(this.name, this.images, this.all, this.amend, this.options, _callback);
        }

        public IDResponse execute() throws ApiException {
            ApiResponse<IDResponse> localVarResp = ManifestsApi.this.manifestCreateLibpodWithHttpInfo(this.name, this.images, this.all, this.amend, this.options);
            return localVarResp.getData();
        }

        public ApiResponse<IDResponse> executeWithHttpInfo() throws ApiException {
            return ManifestsApi.this.manifestCreateLibpodWithHttpInfo(this.name, this.images, this.all, this.amend, this.options);
        }

        public Call executeAsync(ApiCallback<IDResponse> _callback) throws ApiException {
            return ManifestsApi.this.manifestCreateLibpodAsync(this.name, this.images, this.all, this.amend, this.options, _callback);
        }
    }

    public class APImanifestDeleteLibpodRequest {
        private final String name;
        private Boolean ignore;

        private APImanifestDeleteLibpodRequest(String name) {
            this.name = name;
        }

        public APImanifestDeleteLibpodRequest ignore(Boolean ignore) {
            this.ignore = ignore;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ManifestsApi.this.manifestDeleteLibpodCall(this.name, this.ignore, _callback);
        }

        public LibpodImagesRemoveReport execute() throws ApiException {
            ApiResponse<LibpodImagesRemoveReport> localVarResp = ManifestsApi.this.manifestDeleteLibpodWithHttpInfo(this.name, this.ignore);
            return localVarResp.getData();
        }

        public ApiResponse<LibpodImagesRemoveReport> executeWithHttpInfo() throws ApiException {
            return ManifestsApi.this.manifestDeleteLibpodWithHttpInfo(this.name, this.ignore);
        }

        public Call executeAsync(ApiCallback<LibpodImagesRemoveReport> _callback) throws ApiException {
            return ManifestsApi.this.manifestDeleteLibpodAsync(this.name, this.ignore, _callback);
        }
    }

    public class APImanifestExistsLibpodRequest {
        private final String name;

        private APImanifestExistsLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ManifestsApi.this.manifestExistsLibpodCall(this.name, _callback);
        }

        public void execute() throws ApiException {
            ManifestsApi.this.manifestExistsLibpodWithHttpInfo(this.name);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ManifestsApi.this.manifestExistsLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ManifestsApi.this.manifestExistsLibpodAsync(this.name, _callback);
        }
    }

    public class APImanifestInspectLibpodRequest {
        private final String name;
        private Boolean tlsVerify;

        private APImanifestInspectLibpodRequest(String name) {
            this.name = name;
        }

        public APImanifestInspectLibpodRequest tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ManifestsApi.this.manifestInspectLibpodCall(this.name, this.tlsVerify, _callback);
        }

        public Schema2ListPublic execute() throws ApiException {
            ApiResponse<Schema2ListPublic> localVarResp = ManifestsApi.this.manifestInspectLibpodWithHttpInfo(this.name, this.tlsVerify);
            return localVarResp.getData();
        }

        public ApiResponse<Schema2ListPublic> executeWithHttpInfo() throws ApiException {
            return ManifestsApi.this.manifestInspectLibpodWithHttpInfo(this.name, this.tlsVerify);
        }

        public Call executeAsync(ApiCallback<Schema2ListPublic> _callback) throws ApiException {
            return ManifestsApi.this.manifestInspectLibpodAsync(this.name, this.tlsVerify, _callback);
        }
    }

    public class APImanifestModifyLibpodRequest {
        private final String name;
        private final ManifestModifyOptions options;
        private Boolean tlsVerify;

        private APImanifestModifyLibpodRequest(String name, ManifestModifyOptions options) {
            this.name = name;
            this.options = options;
        }

        public APImanifestModifyLibpodRequest tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ManifestsApi.this.manifestModifyLibpodCall(this.name, this.options, this.tlsVerify, _callback);
        }

        public ManifestModifyReport execute() throws ApiException {
            ApiResponse<ManifestModifyReport> localVarResp = ManifestsApi.this.manifestModifyLibpodWithHttpInfo(this.name, this.options, this.tlsVerify);
            return localVarResp.getData();
        }

        public ApiResponse<ManifestModifyReport> executeWithHttpInfo() throws ApiException {
            return ManifestsApi.this.manifestModifyLibpodWithHttpInfo(this.name, this.options, this.tlsVerify);
        }

        public Call executeAsync(ApiCallback<ManifestModifyReport> _callback) throws ApiException {
            return ManifestsApi.this.manifestModifyLibpodAsync(this.name, this.options, this.tlsVerify, _callback);
        }
    }

    public class APImanifestPushLibpodRequest {
        private final String name;
        private final String destination;
        private List<String> addCompression;
        private Boolean forceCompressionFormat;
        private Boolean all;
        private Boolean tlsVerify;
        private Boolean quiet;

        private APImanifestPushLibpodRequest(String name, String destination) {
            this.name = name;
            this.destination = destination;
        }

        public APImanifestPushLibpodRequest addCompression(List<String> addCompression) {
            this.addCompression = addCompression;
            return this;
        }

        public APImanifestPushLibpodRequest forceCompressionFormat(Boolean forceCompressionFormat) {
            this.forceCompressionFormat = forceCompressionFormat;
            return this;
        }

        public APImanifestPushLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public APImanifestPushLibpodRequest tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        public APImanifestPushLibpodRequest quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ManifestsApi.this.manifestPushLibpodCall(this.name, this.destination, this.addCompression, this.forceCompressionFormat, this.all, this.tlsVerify, this.quiet, _callback);
        }

        public IDResponse execute() throws ApiException {
            ApiResponse<IDResponse> localVarResp = ManifestsApi.this.manifestPushLibpodWithHttpInfo(this.name, this.destination, this.addCompression, this.forceCompressionFormat, this.all, this.tlsVerify, this.quiet);
            return localVarResp.getData();
        }

        public ApiResponse<IDResponse> executeWithHttpInfo() throws ApiException {
            return ManifestsApi.this.manifestPushLibpodWithHttpInfo(this.name, this.destination, this.addCompression, this.forceCompressionFormat, this.all, this.tlsVerify, this.quiet);
        }

        public Call executeAsync(ApiCallback<IDResponse> _callback) throws ApiException {
            return ManifestsApi.this.manifestPushLibpodAsync(this.name, this.destination, this.addCompression, this.forceCompressionFormat, this.all, this.tlsVerify, this.quiet, _callback);
        }
    }

    public class APImanifestPushV3LibpodRequest {
        private final String name;
        private final String destination;
        private Boolean all;

        private APImanifestPushV3LibpodRequest(String name, String destination) {
            this.name = name;
            this.destination = destination;
        }

        public APImanifestPushV3LibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ManifestsApi.this.manifestPushV3LibpodCall(this.name, this.destination, this.all, _callback);
        }

        public IDResponse execute() throws ApiException {
            ApiResponse<IDResponse> localVarResp = ManifestsApi.this.manifestPushV3LibpodWithHttpInfo(this.name, this.destination, this.all);
            return localVarResp.getData();
        }

        public ApiResponse<IDResponse> executeWithHttpInfo() throws ApiException {
            return ManifestsApi.this.manifestPushV3LibpodWithHttpInfo(this.name, this.destination, this.all);
        }

        public Call executeAsync(ApiCallback<IDResponse> _callback) throws ApiException {
            return ManifestsApi.this.manifestPushV3LibpodAsync(this.name, this.destination, this.all, _callback);
        }
    }
}

