/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Config;
import io.github.pod4dev.libpodj.model.Descriptor;
import io.github.pod4dev.libpodj.model.DriverData;
import io.github.pod4dev.libpodj.model.ManifestSummary;
import io.github.pod4dev.libpodj.model.Metadata;
import io.github.pod4dev.libpodj.model.RootFS;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ImageInspect
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ARCHITECTURE = "Architecture";
    @SerializedName(value="Architecture")
    private String architecture;
    public static final String SERIALIZED_NAME_AUTHOR = "Author";
    @SerializedName(value="Author")
    private String author;
    public static final String SERIALIZED_NAME_COMMENT = "Comment";
    @SerializedName(value="Comment")
    private String comment;
    public static final String SERIALIZED_NAME_CONFIG = "Config";
    @SerializedName(value="Config")
    private Config config;
    public static final String SERIALIZED_NAME_CONTAINER = "Container";
    @SerializedName(value="Container")
    private String container;
    public static final String SERIALIZED_NAME_CONTAINER_CONFIG = "ContainerConfig";
    @SerializedName(value="ContainerConfig")
    private Config containerConfig;
    public static final String SERIALIZED_NAME_CREATED = "Created";
    @SerializedName(value="Created")
    private String created;
    public static final String SERIALIZED_NAME_DESCRIPTOR = "Descriptor";
    @SerializedName(value="Descriptor")
    private Descriptor descriptor;
    public static final String SERIALIZED_NAME_DOCKER_VERSION = "DockerVersion";
    @SerializedName(value="DockerVersion")
    private String dockerVersion;
    public static final String SERIALIZED_NAME_GRAPH_DRIVER = "GraphDriver";
    @SerializedName(value="GraphDriver")
    private DriverData graphDriver;
    public static final String SERIALIZED_NAME_ID = "Id";
    @SerializedName(value="Id")
    private String id;
    public static final String SERIALIZED_NAME_MANIFESTS = "Manifests";
    @SerializedName(value="Manifests")
    private List<@Valid ManifestSummary> manifests = new ArrayList<ManifestSummary>();
    public static final String SERIALIZED_NAME_METADATA = "Metadata";
    @SerializedName(value="Metadata")
    private Metadata metadata;
    public static final String SERIALIZED_NAME_OS = "Os";
    @SerializedName(value="Os")
    private String os;
    public static final String SERIALIZED_NAME_OS_VERSION = "OsVersion";
    @SerializedName(value="OsVersion")
    private String osVersion;
    public static final String SERIALIZED_NAME_PARENT = "Parent";
    @SerializedName(value="Parent")
    private String parent;
    public static final String SERIALIZED_NAME_REPO_DIGESTS = "RepoDigests";
    @SerializedName(value="RepoDigests")
    private List<String> repoDigests = new ArrayList<String>();
    public static final String SERIALIZED_NAME_REPO_TAGS = "RepoTags";
    @SerializedName(value="RepoTags")
    private List<String> repoTags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ROOT_F_S = "RootFS";
    @SerializedName(value="RootFS")
    private RootFS rootFS;
    public static final String SERIALIZED_NAME_SIZE = "Size";
    @SerializedName(value="Size")
    private Long size;
    public static final String SERIALIZED_NAME_VARIANT = "Variant";
    @SerializedName(value="Variant")
    private String variant;
    public static final String SERIALIZED_NAME_VIRTUAL_SIZE = "VirtualSize";
    @SerializedName(value="VirtualSize")
    private Long virtualSize;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ImageInspect architecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    @Nullable
    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public ImageInspect author(String author) {
        this.author = author;
        return this;
    }

    @Nullable
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public ImageInspect comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ImageInspect config(Config config) {
        this.config = config;
        return this;
    }

    @Nullable
    @Valid
    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public ImageInspect container(String container) {
        this.container = container;
        return this;
    }

    @Nullable
    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public ImageInspect containerConfig(Config containerConfig) {
        this.containerConfig = containerConfig;
        return this;
    }

    @Nullable
    @Valid
    public Config getContainerConfig() {
        return this.containerConfig;
    }

    public void setContainerConfig(Config containerConfig) {
        this.containerConfig = containerConfig;
    }

    public ImageInspect created(String created) {
        this.created = created;
        return this;
    }

    @Nullable
    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public ImageInspect descriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    @Nullable
    @Valid
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ImageInspect dockerVersion(String dockerVersion) {
        this.dockerVersion = dockerVersion;
        return this;
    }

    @Nullable
    public String getDockerVersion() {
        return this.dockerVersion;
    }

    public void setDockerVersion(String dockerVersion) {
        this.dockerVersion = dockerVersion;
    }

    public ImageInspect graphDriver(DriverData graphDriver) {
        this.graphDriver = graphDriver;
        return this;
    }

    @Nullable
    @Valid
    public DriverData getGraphDriver() {
        return this.graphDriver;
    }

    public void setGraphDriver(DriverData graphDriver) {
        this.graphDriver = graphDriver;
    }

    public ImageInspect id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ImageInspect manifests(List<@Valid ManifestSummary> manifests) {
        this.manifests = manifests;
        return this;
    }

    public ImageInspect addManifestsItem(ManifestSummary manifestsItem) {
        if (this.manifests == null) {
            this.manifests = new ArrayList<ManifestSummary>();
        }
        this.manifests.add(manifestsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid ManifestSummary> getManifests() {
        return this.manifests;
    }

    public void setManifests(List<@Valid ManifestSummary> manifests) {
        this.manifests = manifests;
    }

    public ImageInspect metadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @Valid
    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public ImageInspect os(String os) {
        this.os = os;
        return this;
    }

    @Nullable
    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public ImageInspect osVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    @Nullable
    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public ImageInspect parent(String parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public ImageInspect repoDigests(List<String> repoDigests) {
        this.repoDigests = repoDigests;
        return this;
    }

    public ImageInspect addRepoDigestsItem(String repoDigestsItem) {
        if (this.repoDigests == null) {
            this.repoDigests = new ArrayList<String>();
        }
        this.repoDigests.add(repoDigestsItem);
        return this;
    }

    @Nullable
    public List<String> getRepoDigests() {
        return this.repoDigests;
    }

    public void setRepoDigests(List<String> repoDigests) {
        this.repoDigests = repoDigests;
    }

    public ImageInspect repoTags(List<String> repoTags) {
        this.repoTags = repoTags;
        return this;
    }

    public ImageInspect addRepoTagsItem(String repoTagsItem) {
        if (this.repoTags == null) {
            this.repoTags = new ArrayList<String>();
        }
        this.repoTags.add(repoTagsItem);
        return this;
    }

    @Nullable
    public List<String> getRepoTags() {
        return this.repoTags;
    }

    public void setRepoTags(List<String> repoTags) {
        this.repoTags = repoTags;
    }

    public ImageInspect rootFS(RootFS rootFS) {
        this.rootFS = rootFS;
        return this;
    }

    @Nullable
    @Valid
    public RootFS getRootFS() {
        return this.rootFS;
    }

    public void setRootFS(RootFS rootFS) {
        this.rootFS = rootFS;
    }

    public ImageInspect size(Long size) {
        this.size = size;
        return this;
    }

    @Nullable
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public ImageInspect variant(String variant) {
        this.variant = variant;
        return this;
    }

    @Nullable
    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public ImageInspect virtualSize(Long virtualSize) {
        this.virtualSize = virtualSize;
        return this;
    }

    @Nullable
    public Long getVirtualSize() {
        return this.virtualSize;
    }

    public void setVirtualSize(Long virtualSize) {
        this.virtualSize = virtualSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageInspect imageInspect = (ImageInspect)o;
        return Objects.equals(this.architecture, imageInspect.architecture) && Objects.equals(this.author, imageInspect.author) && Objects.equals(this.comment, imageInspect.comment) && Objects.equals(this.config, imageInspect.config) && Objects.equals(this.container, imageInspect.container) && Objects.equals(this.containerConfig, imageInspect.containerConfig) && Objects.equals(this.created, imageInspect.created) && Objects.equals(this.descriptor, imageInspect.descriptor) && Objects.equals(this.dockerVersion, imageInspect.dockerVersion) && Objects.equals(this.graphDriver, imageInspect.graphDriver) && Objects.equals(this.id, imageInspect.id) && Objects.equals(this.manifests, imageInspect.manifests) && Objects.equals(this.metadata, imageInspect.metadata) && Objects.equals(this.os, imageInspect.os) && Objects.equals(this.osVersion, imageInspect.osVersion) && Objects.equals(this.parent, imageInspect.parent) && Objects.equals(this.repoDigests, imageInspect.repoDigests) && Objects.equals(this.repoTags, imageInspect.repoTags) && Objects.equals(this.rootFS, imageInspect.rootFS) && Objects.equals(this.size, imageInspect.size) && Objects.equals(this.variant, imageInspect.variant) && Objects.equals(this.virtualSize, imageInspect.virtualSize);
    }

    public int hashCode() {
        return Objects.hash(this.architecture, this.author, this.comment, this.config, this.container, this.containerConfig, this.created, this.descriptor, this.dockerVersion, this.graphDriver, this.id, this.manifests, this.metadata, this.os, this.osVersion, this.parent, this.repoDigests, this.repoTags, this.rootFS, this.size, this.variant, this.virtualSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageInspect {\n");
        sb.append("    architecture: ").append(this.toIndentedString(this.architecture)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    container: ").append(this.toIndentedString(this.container)).append("\n");
        sb.append("    containerConfig: ").append(this.toIndentedString(this.containerConfig)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    descriptor: ").append(this.toIndentedString(this.descriptor)).append("\n");
        sb.append("    dockerVersion: ").append(this.toIndentedString(this.dockerVersion)).append("\n");
        sb.append("    graphDriver: ").append(this.toIndentedString(this.graphDriver)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    manifests: ").append(this.toIndentedString(this.manifests)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    os: ").append(this.toIndentedString(this.os)).append("\n");
        sb.append("    osVersion: ").append(this.toIndentedString(this.osVersion)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    repoDigests: ").append(this.toIndentedString(this.repoDigests)).append("\n");
        sb.append("    repoTags: ").append(this.toIndentedString(this.repoTags)).append("\n");
        sb.append("    rootFS: ").append(this.toIndentedString(this.rootFS)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    variant: ").append(this.toIndentedString(this.variant)).append("\n");
        sb.append("    virtualSize: ").append(this.toIndentedString(this.virtualSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraymanifests;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ImageInspect is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ImageInspect` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ARCHITECTURE) != null && !jsonObj.get(SERIALIZED_NAME_ARCHITECTURE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARCHITECTURE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Architecture` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARCHITECTURE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHOR) != null && !jsonObj.get(SERIALIZED_NAME_AUTHOR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AUTHOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Author` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMENT) != null && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Comment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonNull()) {
            Config.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTAINER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Container` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER_CONFIG).isJsonNull()) {
            Config.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONTAINER_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREATED) != null && !jsonObj.get(SERIALIZED_NAME_CREATED).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREATED).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Created` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATED).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTOR) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTOR).isJsonNull()) {
            Descriptor.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DESCRIPTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOCKER_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_DOCKER_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DOCKER_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `DockerVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCKER_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GRAPH_DRIVER) != null && !jsonObj.get(SERIALIZED_NAME_GRAPH_DRIVER).isJsonNull()) {
            DriverData.validateJsonElement(jsonObj.get(SERIALIZED_NAME_GRAPH_DRIVER));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MANIFESTS) != null && !jsonObj.get(SERIALIZED_NAME_MANIFESTS).isJsonNull() && (jsonArraymanifests = jsonObj.getAsJsonArray(SERIALIZED_NAME_MANIFESTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MANIFESTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Manifests` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MANIFESTS).toString()));
            }
            for (int i = 0; i < jsonArraymanifests.size(); ++i) {
                ManifestSummary.validateJsonElement(jsonArraymanifests.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_METADATA).isJsonNull()) {
            Metadata.validateJsonElement(jsonObj.get(SERIALIZED_NAME_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_OS) != null && !jsonObj.get(SERIALIZED_NAME_OS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Os` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OS_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_OS_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OS_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `OsVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OS_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PARENT) != null && !jsonObj.get(SERIALIZED_NAME_PARENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PARENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Parent` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPO_DIGESTS) != null && !jsonObj.get(SERIALIZED_NAME_REPO_DIGESTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REPO_DIGESTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `RepoDigests` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPO_DIGESTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPO_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_REPO_TAGS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REPO_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `RepoTags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPO_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROOT_F_S) != null && !jsonObj.get(SERIALIZED_NAME_ROOT_F_S).isJsonNull()) {
            RootFS.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ROOT_F_S));
        }
        if (jsonObj.get(SERIALIZED_NAME_VARIANT) != null && !jsonObj.get(SERIALIZED_NAME_VARIANT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VARIANT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Variant` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIANT).toString()));
        }
    }

    public static ImageInspect fromJson(String jsonString) throws IOException {
        return (ImageInspect)JSON.getGson().fromJson(jsonString, ImageInspect.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ARCHITECTURE);
        openapiFields.add(SERIALIZED_NAME_AUTHOR);
        openapiFields.add(SERIALIZED_NAME_COMMENT);
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_CONTAINER);
        openapiFields.add(SERIALIZED_NAME_CONTAINER_CONFIG);
        openapiFields.add(SERIALIZED_NAME_CREATED);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTOR);
        openapiFields.add(SERIALIZED_NAME_DOCKER_VERSION);
        openapiFields.add(SERIALIZED_NAME_GRAPH_DRIVER);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_MANIFESTS);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_OS);
        openapiFields.add(SERIALIZED_NAME_OS_VERSION);
        openapiFields.add(SERIALIZED_NAME_PARENT);
        openapiFields.add(SERIALIZED_NAME_REPO_DIGESTS);
        openapiFields.add(SERIALIZED_NAME_REPO_TAGS);
        openapiFields.add(SERIALIZED_NAME_ROOT_F_S);
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiFields.add(SERIALIZED_NAME_VARIANT);
        openapiFields.add(SERIALIZED_NAME_VIRTUAL_SIZE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ImageInspect.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ImageInspect.class));
            return new TypeAdapter<ImageInspect>(this){

                public void write(JsonWriter out, ImageInspect value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ImageInspect read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ImageInspect.validateJsonElement(jsonElement);
                    return (ImageInspect)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

