/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.java;

import io.github.pod4dev.java.FixedApiClient;
import io.github.pod4dev.java.GenericContainer;
import io.github.pod4dev.java.ServiceBinding;
import io.github.pod4dev.java.Utils;
import io.github.pod4dev.java.exceptions.PodmanException;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.api.PodsApi;
import io.github.pod4dev.libpodj.model.PlayKubeReport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.net.SocketFactory;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.unixdomainsockets.UnixDomainSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubePlayer
implements GenericContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubePlayer.class);
    private final ApiClient api;
    private final String yamlPath;
    private final String hostname;
    private final List<ServiceBinding> servicesBindings = new ArrayList<ServiceBinding>();
    private boolean doCleanup = true;
    private boolean doRemoveVolumes = true;

    private KubePlayer(URI podmanUri, String yamlPath) throws PodmanException {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        this.api = new FixedApiClient();
        this.hostname = Utils.getHost(podmanUri);
        switch (podmanUri.getScheme().toLowerCase()) {
            case "unix": {
                httpClientBuilder.socketFactory((SocketFactory)new UnixDomainSocketFactory(new File(podmanUri.getPath())));
                this.api.setBasePath("http://localhost/v5.0.0");
                break;
            }
            case "http": 
            case "https": 
            case "tcp": {
                this.api.setBasePath(podmanUri.toString());
                break;
            }
            default: {
                throw new PodmanException("Wrong schema");
            }
        }
        this.api.setHttpClient(httpClientBuilder.build());
        this.yamlPath = yamlPath;
    }

    public KubePlayer(String yamlPath) throws PodmanException {
        this(Utils.getPodmanUri(), yamlPath);
    }

    @Override
    public KubePlayer withExposedService(String serviceName, int exposedPort) throws PodmanException {
        Predicate<ServiceBinding> isBindingExist = serviceBinding -> Objects.equals(serviceBinding.getServiceName(), serviceName) && Objects.equals(serviceBinding.getExposedPort(), exposedPort);
        if (!this.servicesBindings.isEmpty() && this.servicesBindings.stream().anyMatch(isBindingExist)) {
            throw new PodmanException("Binging[serviceName=%s, exposedPort=%d] already exists".formatted(serviceName, exposedPort));
        }
        int mappedPort = Utils.findFreePort(this.servicesBindings.stream().map(ServiceBinding::getMappedPort).toList());
        this.servicesBindings.add(new ServiceBinding(serviceName, this.hostname, exposedPort, mappedPort));
        return this;
    }

    @Override
    public KubePlayer withCleanup(boolean doCleanup) {
        this.doCleanup = doCleanup;
        return this;
    }

    @Override
    public KubePlayer withRemoveVolumes(boolean doRemoveVolumes) {
        this.doRemoveVolumes = doRemoveVolumes;
        return this;
    }

    @Override
    public void start() throws PodmanException {
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        PodsApi podsApi = new PodsApi(this.api);
        String yaml = null;
        try {
            yaml = Utils.readYaml(this.yamlPath);
        }
        catch (IOException e) {
            throw new PodmanException(e);
        }
        PlayKubeReport report = null;
        try {
            List<String> ports = this.servicesBindings.stream().map(serviceBinding -> "%d:%d".formatted(serviceBinding.getMappedPort(), serviceBinding.getExposedPort())).toList();
            report = podsApi.playKubeLibpod_0().publishPorts(ports).wait(Boolean.valueOf(this.doCleanup)).start(Boolean.valueOf(true)).request(yaml).execute();
        }
        catch (ApiException e) {
            throw new PodmanException(e);
        }
        if (report == null || report.getPods() == null || report.getPods().isEmpty()) {
            throw new PodmanException("There is no related pods");
        }
    }

    @Override
    public void stop() throws PodmanException {
        PodsApi pods = new PodsApi(this.api);
        String yaml = null;
        try {
            yaml = Utils.readYaml(this.yamlPath);
        }
        catch (IOException e) {
            throw new PodmanException(e);
        }
        try {
            pods.playKubeDownLibpod_0().force(Boolean.valueOf(this.doRemoveVolumes)).request(yaml).execute();
        }
        catch (ApiException e) {
            throw new PodmanException(e);
        }
    }

    @Override
    public String getMappedHost(String serviceName, int exposedPort) {
        Predicate<ServiceBinding> isBindingExist = serviceBinding -> Objects.equals(serviceBinding.getServiceName(), serviceName) && Objects.equals(serviceBinding.getExposedPort(), exposedPort);
        return this.servicesBindings.stream().filter(isBindingExist).map(ServiceBinding::getMappedHost).findAny().orElse(null);
    }

    @Override
    public int getMappedPort(String serviceName, int exposedPort) throws PodmanException {
        Predicate<ServiceBinding> isBindingExist = serviceBinding -> Objects.equals(serviceBinding.getServiceName(), serviceName) && Objects.equals(serviceBinding.getExposedPort(), exposedPort);
        return this.servicesBindings.stream().filter(isBindingExist).map(ServiceBinding::getMappedPort).findAny().orElseThrow(() -> new PodmanException("Here is no mapped port"));
    }
}

