/*
 * Decompiled with CFR 0.152.
 */
package io.github.resttestcases.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.resttestcases.core.Factory;
import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.filter.log.LogDetail;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.filter.log.ResponseLoggingFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class Context {
    protected ObjectMapper mapper;
    protected ObjectMapper mapperJson;
    protected static Logger logger = Factory.getLogger();
    protected static Logger loggerRequets = Factory.getLoggerHTTP();
    private static ByteArrayOutputStream requestLog;
    private static ByteArrayOutputStream responseLog;
    private Map<String, Object> parans = new HashMap<String, Object>();

    public Context() {
        this.init();
    }

    private void init() {
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.mapper.findAndRegisterModules();
        this.mapperJson = new ObjectMapper();
        this.mapperJson.findAndRegisterModules();
        Context.configRestAssuredLogs();
    }

    public void setParam(String name, Object req) {
        this.parans.put(name, req);
    }

    public <T> T getParam(String name) {
        return (T)this.parans.get(name);
    }

    public <T> T removeParam(String name) {
        return (T)this.parans.remove(name);
    }

    public static Logger getLogger() {
        return logger;
    }

    private static void configRestAssuredLogs() {
        if (loggerRequets.isDebugEnabled() && requestLog == null) {
            requestLog = new ByteArrayOutputStream();
            responseLog = new ByteArrayOutputStream();
            PrintStream requestPrint = new PrintStream(requestLog);
            PrintStream responsePrint = new PrintStream(responseLog);
            RequestLoggingFilter requestLoggingFilter = new RequestLoggingFilter(LogDetail.ALL, true, requestPrint);
            ResponseLoggingFilter responseLoggingFilter = new ResponseLoggingFilter(LogDetail.ALL, true, responsePrint);
            RestAssured.filters((Filter)requestLoggingFilter, (Filter[])new Filter[]{responseLoggingFilter});
        }
    }

    public static void logHttpReset() {
        if (loggerRequets.isDebugEnabled()) {
            requestLog.reset();
            responseLog.reset();
        }
    }

    public void logRequest() {
        try {
            if (loggerRequets.isDebugEnabled()) {
                loggerRequets.debug("\r\n-----------------------------------Request Data---------------------------------\r\n" + requestLog.toString("UTF-8") + "\r\n-----------------------------------End Request Data-----------------------------\r\n");
                requestLog.reset();
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void logResponse() {
        try {
            if (loggerRequets.isDebugEnabled()) {
                loggerRequets.debug("\r\n-----------------------------------Response Data--------------------------------\r\n" + responseLog.toString("UTF-8") + "\r\n-----------------------------------End Response Data----------------------------\r\n");
                responseLog.reset();
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public JsonNode toJsonNode(String str) throws IOException {
        return this.mapperJson.readTree(str);
    }
}

